/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextView;
import com.apple.library.uikit.UIView;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import moe.plushie.armourers_workshop.api.common.IResource;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.client.gui.widget.BaseDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinComboBox;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPack;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPackReader;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModel;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelExporter;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockTransform;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchReader;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;

public class SkinImportDialog
extends BaseDialog {
    private static final ImmutableMap<ISkinType, Collection<ISkinProperty<Boolean>>> TTTT = new ImmutableMap.Builder().put((Object)SkinTypes.OUTFIT, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.OVERRIDE_EQUIPMENT_HELMET, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS)).put((Object)SkinTypes.ARMOR_HEAD, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_EQUIPMENT_HELMET)).put((Object)SkinTypes.ARMOR_CHEST, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE)).put((Object)SkinTypes.ARMOR_FEET, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS)).put((Object)SkinTypes.ARMOR_LEGS, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS)).put((Object)SkinTypes.ARMOR_WINGS, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_SWORD, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_SHIELD, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_BOW, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_TRIDENT, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.TOOL_PICKAXE, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.TOOL_AXE, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.TOOL_SHOVEL, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.TOOL_HOE, ObjectUtils.map(new ISkinProperty[0])).build();
    private final UITextField inputTextField = new UITextField(CGRect.ZERO);
    private final SkinComboBox skinTypeList = new SkinComboBox(CGRect.ZERO);
    private final UITextField textName = new UITextField(CGRect.ZERO);
    private final UITextView textDescription = new UITextView(CGRect.ZERO);
    private final UIScrollView scrollView = new UIScrollView(CGRect.ZERO);
    private final ArrayList<UICheckBox> boxes = new ArrayList();
    private final HashMap<ISkinProperty<Boolean>, Boolean> values = new HashMap();

    public SkinImportDialog(CGRect rect) {
        super(rect.insetBy(16.0f, 16.0f, 16.0f, 16.0f));
        this.setup();
    }

    private void setup() {
        float width = this.bounds().width - 16.0f;
        float height = this.bounds().height;
        float left = 8.0f;
        float top = 20.0f;
        float sw = (width - 4.0f) / 2.0f;
        UILabel t = new UILabel(new CGRect(left, 8.0f, width, 10.0f));
        t.setText(new NSString("Skin Importer"));
        t.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        t.setAutoresizingMask(34);
        this.addSubview(t);
        this.inputTextField.setFrame(new CGRect(left + (sw + 4.0f) * 0.0f, top, sw, 16.0f));
        this.inputTextField.setPlaceholder(new NSString("Input .bbmodel file name"));
        this.inputTextField.setAutoresizingMask(34);
        this.addSubview(this.inputTextField);
        this.skinTypeList.setFrame(new CGRect(left + (sw + 4.0f) * 1.0f, top, sw, 16.0f));
        this.skinTypeList.setMaxRows(10);
        this.skinTypeList.setAutoresizingMask(34);
        this.skinTypeList.reloadSkins(new ArrayList<ISkinType>((Collection<ISkinType>)TTTT.keySet()));
        this.skinTypeList.setSelectedSkin(SkinTypes.OUTFIT);
        this.skinTypeList.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinImportDialog::addProperties);
        this.addSubview(this.skinTypeList);
        float qw = width / 2.0f;
        float ql = left + qw;
        float qt = top += 20.0f;
        this.textName.setFrame(new CGRect(left, top, qw * 0.8f, 16.0f));
        this.textName.setPlaceholder(new NSString("Input Skin Name"));
        this.textName.setMaxLength(255);
        this.textName.setAutoresizingMask(2);
        this.addSubview(this.textName);
        this.textDescription.setFrame(new CGRect(left, top += 18.0f, qw - 4.0f, 64.0f));
        this.textDescription.setPlaceholder(new NSString("Input SKin Description"));
        this.textDescription.setAutoresizingMask(18);
        this.textDescription.setMaxLength(255);
        this.addSubview(this.textDescription);
        this.scrollView.setFrame(new CGRect(ql + 4.0f, qt, qw, height - qt - 8.0f - 24.0f - 8.0f));
        this.insertViewAtIndex(this.scrollView, 0);
        float bw = 100.0f;
        float bl = (width - bw) / 2.0f;
        UIButton act = new UIButton(new CGRect(left + bl, height - 24.0f - 8.0f, bw, 24.0f));
        act.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        act.setTitle(new NSString("Start"), 0);
        act.addTarget(this, UIControl.Event.MOUSE_LEFT_UP, SkinImportDialog::startImport);
        act.setAutoresizingMask(13);
        this.addSubview(act);
        this.addProperties(this.skinTypeList);
    }

    private void addProperties(UIControl sender) {
        this.boxes.forEach(UIView::removeFromSuperview);
        Collection bb = (Collection)TTTT.get((Object)this.skinTypeList.selectedSkin());
        if (bb == null || bb.isEmpty()) {
            return;
        }
        float width = this.scrollView.frame().getWidth();
        float top = 0.0f;
        for (ISkinProperty p : bb) {
            UICheckBox checkBox = new UICheckBox(new CGRect(0.0f, top, width, 10.0f));
            checkBox.setTitle(NSString.localizedString("armourer.skinSettings." + p.getKey(), new Object[0]));
            checkBox.setSelected((Boolean)p.getDefaultValue());
            checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
                UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
                self.values.put(p, checkBox1.isSelected());
            });
            this.boxes.add(checkBox);
            this.scrollView.addSubview(checkBox);
            top += 10.0f;
        }
        this.scrollView.setContentSize(new CGSize(0.0f, top));
    }

    private void startImport(UIControl sender) {
        sender.setEnabled(false);
        String fileName = this.inputTextField.text();
        try {
            if (fileName == null || fileName.isEmpty()) {
                throw new RuntimeException("pls input file name not found");
            }
            File root = new File(EnvironmentManager.getRootDirectory(), "model-imports");
            File inputFile = new File(root, fileName);
            if (!inputFile.exists()) {
                throw new RuntimeException(inputFile + " not found");
            }
            File outputFile = new File(root, SkinFileUtils.removeExtension(fileName) + ".armour");
            if (outputFile.exists()) {
                outputFile.delete();
            }
            Skin skin = this.readSkinFromFile(inputFile);
            ModLog.debug("{}", skin);
            SkinFileStreamUtils.saveSkinToFile(outputFile, skin);
            ModLog.debug("{}", skin);
            UserNotificationCenter.showToast(outputFile.getName(), " Import Success", null);
            this.dismiss();
        }
        catch (Exception e) {
            UserNotificationCenter.showToast(e, "Import Failure", null);
        }
        sender.setEnabled(true);
    }

    public Skin readSkinFromFile(File file) throws IOException {
        String name = file.getName();
        Collection<IResource> resources = this.getResourcesFromFile(file);
        return this.readSkinFromReader(BlockBenchReader.from(name, resources));
    }

    public Skin readSkinFromReader(SkinPackReader reader) throws IOException {
        ISkinType skinType;
        BedrockModelExporter exporter = new BedrockModelExporter();
        reader.loadEntityModel(modelReader -> {
            Map<String, BedrockTransform> transforms;
            BedrockModel model = modelReader.readModel();
            for (BedrockModelGeometry geometry : model.getGeometries()) {
                BedrockModelTexture texture = modelReader.readTexture(geometry);
                for (BedrockModelBone bone : geometry.getBones()) {
                    exporter.add(bone, texture);
                }
            }
            SkinPack pack = modelReader.getPack();
            if (pack != null) {
                List<String> authors;
                String description;
                String name2 = pack.getName();
                if (name2 != null && !name2.isEmpty()) {
                    exporter.add(SkinProperty.ALL_CUSTOM_NAME, name2);
                }
                if ((description = pack.getDescription()) != null && !description.isEmpty()) {
                    exporter.add(SkinProperty.ALL_FLAVOUR_TEXT, description);
                }
                if ((authors = pack.getAuthors()) != null && !authors.isEmpty()) {
                    StringBuilder builder = null;
                    for (String a : authors) {
                        if (builder == null) {
                            builder = new StringBuilder(a);
                            continue;
                        }
                        builder.append(",");
                        builder.append(a);
                    }
                    exporter.add(SkinProperty.ALL_AUTHOR_NAME, builder.toString());
                }
            }
            if ((transforms = modelReader.getTransforms()) != null) {
                transforms.forEach((name, transform) -> {
                    Vector3f scale;
                    Vector3f rotation;
                    Vector3f translation = transform.getTranslation();
                    SkinTransform transform1 = SkinTransform.create(translation, rotation = transform.getRotation(), scale = transform.getScale());
                    if (!transform1.isIdentity()) {
                        exporter.add((String)name, transform1);
                    }
                });
            }
        });
        exporter.add(SkinProperty.ALL_CUSTOM_NAME, this.textName.text());
        exporter.add(SkinProperty.ALL_FLAVOUR_TEXT, this.textDescription.text());
        GameProfile origin = Minecraft.func_71410_x().func_110432_I().func_148256_e();
        exporter.add(SkinProperty.ALL_AUTHOR_NAME, origin.getName());
        if (origin.getId() != null) {
            exporter.add(SkinProperty.ALL_AUTHOR_UUID, origin.getId().toString());
        }
        if ((skinType = this.skinTypeList.selectedSkin()) == SkinTypes.OUTFIT) {
            exporter.move(new Vector3f(0.0f, -24.0f, 0.0f));
        }
        this.values.forEach(exporter::add);
        return exporter.export(skinType);
    }

    private Collection<IResource> getResourcesFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            return this.getResourcesFromDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return this.getResourcesFromZip(file);
        }
        return this.getResourcesFromSet(file);
    }

    private Collection<IResource> getResourcesFromZip(File zipFile) throws IOException {
        ZipEntry entry;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        final ZipFile file = new ZipFile(zipFile);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            final ZipEntry fileEntry = entry;
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return file.getInputStream(fileEntry);
                }
            });
        }
        return resources;
    }

    private Collection<IResource> getResourcesFromDirectory(File rootPath) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : SkinFileUtils.listAllFiles(rootPath)) {
            if (entry.isDirectory()) continue;
            final String fileName = SkinFileUtils.getRelativePath(entry, rootPath, true).substring(1);
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    private Collection<IResource> getResourcesFromSet(File ... entries) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : entries) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }
}

