/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.utils.math.OpenBoundingBox;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenTransformedBoundingBox {
    private final OpenMatrix4f transform;
    private final OpenBoundingBox boundingBox;
    private OpenBoundingBox transformedBoundingBox;
    private Vector3f size;
    private ArrayList<Vector3f> vertices;

    public OpenTransformedBoundingBox(OpenMatrix4f transform, OpenBoundingBox boundingBox) {
        this.transform = transform;
        this.boundingBox = boundingBox;
    }

    public ArrayList<Vector3f> getVertices() {
        if (this.vertices == null) {
            this.vertices = this._vertexs(this.boundingBox);
            for (Vector3f v : this.vertices) {
                v.transform(this.transform);
            }
        }
        return this.vertices;
    }

    public boolean intersects(OpenBoundingBox box) {
        return this.getTransformedBoundingBox().intersects(box);
    }

    public OpenMatrix4f getTransform() {
        return this.transform;
    }

    public OpenBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public OpenBoundingBox getTransformedBoundingBox() {
        if (this.transformedBoundingBox == null) {
            this.transformedBoundingBox = this.boundingBox.transforming(this.transform);
        }
        return this.transformedBoundingBox;
    }

    private ArrayList<Vector3f> _vertexs(OpenBoundingBox box) {
        ArrayList<Vector3f> v = new ArrayList<Vector3f>();
        v.add(new Vector3f(box.getMinX(), box.getMinY(), box.getMinZ()));
        v.add(new Vector3f(box.getMaxX(), box.getMinY(), box.getMinZ()));
        v.add(new Vector3f(box.getMinX(), box.getMaxY(), box.getMinZ()));
        v.add(new Vector3f(box.getMaxX(), box.getMaxY(), box.getMinZ()));
        v.add(new Vector3f(box.getMinX(), box.getMinY(), box.getMaxZ()));
        v.add(new Vector3f(box.getMaxX(), box.getMinY(), box.getMaxZ()));
        v.add(new Vector3f(box.getMinX(), box.getMaxY(), box.getMaxZ()));
        v.add(new Vector3f(box.getMaxX(), box.getMaxY(), box.getMaxZ()));
        return v;
    }
}

