/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.common.ITextureProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;

public class TextureProperties
implements ITextureProperties {
    public static final TextureProperties EMPTY = new TextureProperties();
    private int flags = 0;

    public void readFromStream(IInputStream stream) throws IOException {
        this.flags = stream.readInt();
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeInt(this.flags);
    }

    public void setEmissive(boolean isEmissive) {
        this.setFlag(0, isEmissive);
    }

    @Override
    public boolean isEmissive() {
        return this.getFlag(0);
    }

    public void setAdditive(boolean isAdditive) {
        this.setFlag(1, isAdditive);
    }

    public boolean isAdditive() {
        return this.getFlag(1);
    }

    public String toString() {
        if (this == EMPTY) {
            return "[]";
        }
        return String.format("[emissive=%s, additive=%s]", this.isEmissive(), this.isAdditive());
    }

    private void setFlag(int bit, boolean value) {
        this.flags = value ? (this.flags |= 1 << bit) : (this.flags &= ~(1 << bit));
    }

    private boolean getFlag(int bit) {
        return (this.flags & 1 << bit) != 0;
    }
}

