/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketBankGet;
import noppes.npcs.packets.server.SPacketBankRemove;
import noppes.npcs.packets.server.SPacketBankSave;
import noppes.npcs.packets.server.SPacketBanksGet;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScroll;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiData;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.gui.listeners.IScrollData;
import noppes.npcs.shared.client.gui.listeners.ITextfieldListener;

public class GuiNPCManageBanks
extends GuiContainerNPCInterface2<ContainerManageBanks>
implements IScrollData,
ICustomScrollListener,
ITextfieldListener,
IGuiData {
    private GuiCustomScroll scroll;
    private Map<String, Integer> data = new HashMap<String, Integer>();
    private ContainerManageBanks container;
    private Bank bank = new Bank();
    private String selected = null;

    public GuiNPCManageBanks(ContainerManageBanks container, PlayerInventory inv, ITextComponent titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.drawDefaultBackground = false;
        this.setBackground("npcbanksetup.png");
        this.field_147000_g = 200;
        Packets.sendServer(new SPacketBanksGet());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addButton(new GuiButtonNop(this, 6, this.guiLeft + 340, this.guiTop + 10, 45, 20, "gui.add"));
        this.addButton(new GuiButtonNop(this, 7, this.guiLeft + 340, this.guiTop + 32, 45, 20, "gui.remove"));
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll((Screen)this, 0);
            this.scroll.func_231149_a_(160, 180);
        }
        this.scroll.guiLeft = this.guiLeft + 174;
        this.scroll.guiTop = this.guiTop + 8;
        this.addScroll(this.scroll);
        for (int i = 0; i < 6; ++i) {
            int x = this.guiLeft + 6;
            int y = this.guiTop + 36 + i * 22;
            this.addButton(new GuiButtonNop((IGuiInterface)this, i, x + 50, y, 80, 20, new String[]{"bank.canUpgrade", "bank.cantUpgrade", "bank.upgraded"}, 0));
            this.getButton(i).setEnabled(false);
        }
        this.addTextField(new GuiTextFieldNop(0, (Screen)this, this.guiLeft + 8, this.guiTop + 8, 160, 16, ""));
        this.getTextField(0).func_146203_f(20);
        this.addTextField(new GuiTextFieldNop(1, (Screen)this, this.guiLeft + 10, this.guiTop + 80, 16, 16, ""));
        this.getTextField((int)1).numbersOnly = true;
        this.getTextField(1).func_146203_f(1);
        this.addTextField(new GuiTextFieldNop(2, (Screen)this, this.guiLeft + 10, this.guiTop + 110, 16, 16, ""));
        this.getTextField((int)2).numbersOnly = true;
        this.getTextField(2).func_146203_f(1);
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        GuiButtonNop button = guibutton;
        if (button.id == 6) {
            this.save();
            this.scroll.clear();
            String name = "New";
            while (this.data.containsKey(name)) {
                name = name + "_";
            }
            Bank bank = new Bank();
            bank.name = name;
            CompoundNBT compound = new CompoundNBT();
            bank.addAdditionalSaveData(compound);
            Packets.sendServer(new SPacketBankSave(compound));
        } else if (button.id == 7) {
            if (this.data.containsKey(this.scroll.getSelected())) {
                Packets.sendServer(new SPacketBankRemove(this.data.get(this.selected)));
            }
        } else if (button.id >= 0 && button.id < 6) {
            this.bank.slotTypes.put(button.id, button.getValue());
        }
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int par1, int limbSwingAmount) {
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"bank.tabCost", (Object[])new Object[0]), 23.0f, 28.0f, CustomNpcResourceListener.DefaultTextColor);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"bank.upgCost", (Object[])new Object[0]), 123.0f, 28.0f, CustomNpcResourceListener.DefaultTextColor);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.start", (Object[])new Object[0]), 6.0f, 70.0f, CustomNpcResourceListener.DefaultTextColor);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.max", (Object[])new Object[0]), 9.0f, 100.0f, CustomNpcResourceListener.DefaultTextColor);
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        Bank bank = new Bank();
        bank.readAdditionalSaveData(compound);
        this.bank = bank;
        if (bank.id == -1) {
            this.getTextField(0).func_146180_a("");
            this.getTextField(1).func_146180_a("");
            this.getTextField(2).func_146180_a("");
            for (int i = 0; i < 6; ++i) {
                this.getButton(i).setDisplay(0);
                this.getButton(i).setEnabled(false);
            }
        } else {
            this.getTextField(0).func_146180_a(bank.name);
            this.getTextField(1).func_146180_a(Integer.toString(bank.startSlots));
            this.getTextField(2).func_146180_a(Integer.toString(bank.maxSlots));
            for (int i = 0; i < 6; ++i) {
                int type = 0;
                if (bank.slotTypes.containsKey(i)) {
                    type = bank.slotTypes.get(i);
                }
                this.getButton(i).setDisplay(type);
                this.getButton(i).setEnabled(true);
            }
        }
        this.setSelected(bank.name);
    }

    @Override
    public void setData(Vector<String> list, Map<String, Integer> data) {
        String name = this.scroll.getSelected();
        this.data = data;
        this.scroll.setList(list);
        if (name != null) {
            this.scroll.setSelected(name);
        }
    }

    @Override
    public void setSelected(String selected) {
        this.selected = selected;
        this.scroll.setSelected(selected);
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll guiCustomScroll) {
        if (guiCustomScroll.id == 0) {
            this.save();
            this.selected = this.scroll.getSelected();
            Packets.sendServer(new SPacketBankGet(this.data.get(this.selected)));
        }
    }

    @Override
    public void save() {
        if (this.selected != null && this.data.containsKey(this.selected) && this.bank != null) {
            CompoundNBT compound = new CompoundNBT();
            this.bank.currencyInventory = this.container.bank.currencyInventory;
            this.bank.upgradeInventory = this.container.bank.upgradeInventory;
            this.bank.addAdditionalSaveData(compound);
            Packets.sendServer(new SPacketBankSave(compound));
        }
    }

    @Override
    public void unFocused(GuiTextFieldNop guiNpcTextField) {
        if (this.bank.id != -1) {
            if (guiNpcTextField.id == 0) {
                String name = guiNpcTextField.func_146179_b();
                if (!name.isEmpty() && !this.data.containsKey(name)) {
                    String old = this.bank.name;
                    this.data.remove(this.bank.name);
                    this.bank.name = name;
                    this.data.put(this.bank.name, this.bank.id);
                    this.selected = name;
                    this.scroll.replace(old, this.bank.name);
                }
            } else if (guiNpcTextField.id == 1 || guiNpcTextField.id == 2) {
                int num = 1;
                if (!guiNpcTextField.isEmpty()) {
                    num = guiNpcTextField.getInteger();
                }
                if (num > 6) {
                    num = 6;
                }
                if (num < 0) {
                    num = 0;
                }
                if (guiNpcTextField.id == 1) {
                    this.bank.startSlots = num;
                } else if (guiNpcTextField.id == 2) {
                    this.bank.maxSlots = num;
                }
                if (this.bank.startSlots > this.bank.maxSlots) {
                    this.bank.maxSlots = this.bank.startSlots;
                }
                guiNpcTextField.func_146180_a(Integer.toString(num));
            }
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

