/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;

public class CmdQuest {
    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"quest");
        command.then(Commands.func_197057_a((String)"start").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                QuestData questdata = new QuestData(quest);
                data.questData.activeQuests.put(quest.id, questdata);
                data.save(true);
                Packets.send(player, new PacketAchievement((ITextComponent)new TranslationTextComponent("quest.newquest"), (ITextComponent)new TranslationTextComponent(quest.title), 2));
                Packets.send(player, new PacketChat((ITextComponent)new TranslationTextComponent("quest.newquest").func_240702_b_(":").func_230529_a_((ITextComponent)new TranslationTextComponent(quest.title))));
            }
            return 1;
        }))));
        command.then(Commands.func_197057_a((String)"finish").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                data.questData.finishedQuests.put(quest.id, System.currentTimeMillis());
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.func_197057_a((String)"stop").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                data.questData.activeQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                data.questData.activeQuests.remove(quest.id);
                data.questData.finishedQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(Commands.func_197057_a((String)"objective").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            for (ServerPlayerEntity player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((PlayerEntity)player);
                if (!data.questData.activeQuests.containsKey(quest.id)) continue;
                for (IQuestObjective ob : objectives = quest.questInterface.getObjectives((PlayerEntity)player)) {
                    player.func_145747_a(ob.getMCText(), Util.field_240973_b_);
                }
            }
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"objective", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            for (ServerPlayerEntity player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((PlayerEntity)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((PlayerEntity)player)).length) continue;
                player.func_145747_a(objectives[objective].getMCText(), Util.field_240973_b_);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown QuestID"));
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            for (ServerPlayerEntity player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((PlayerEntity)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((PlayerEntity)player)).length) continue;
                objectives[objective].setProgress(value);
            }
            return 1;
        }))))));
        ((LiteralArgumentBuilder)command.requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"reload").executes(context -> {
            new QuestController().load();
            SyncController.syncAllQuests();
            return 1;
        }));
        return command;
    }
}

