/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.controllers.ServerCloneController;

public class CloneSpawnData {
    public int tab;
    public String name;
    private long lastLoaded;
    private CompoundNBT compound;

    public CloneSpawnData(int tab, String name) {
        this.name = name;
        this.tab = tab;
    }

    public CompoundNBT getCompound() {
        if (this.lastLoaded < ServerCloneController.Instance.lastLoaded) {
            this.compound = ServerCloneController.Instance.getCloneData(null, this.name, this.tab);
            this.lastLoaded = ServerCloneController.Instance.lastLoaded;
        }
        return this.compound;
    }

    public static Map<Integer, CloneSpawnData> load(ListNBT list) {
        HashMap<Integer, CloneSpawnData> data = new HashMap<Integer, CloneSpawnData>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            int tab = c.func_74762_e("tab");
            String name = c.func_74779_i("name");
            if (ServerCloneController.Instance != null && !ServerCloneController.Instance.hasClone(tab, name)) continue;
            data.put(c.func_74762_e("slot"), new CloneSpawnData(tab, name));
        }
        return data;
    }

    public static ListNBT save(Map<Integer, CloneSpawnData> data) {
        ListNBT list = new ListNBT();
        for (Map.Entry<Integer, CloneSpawnData> entry : data.entrySet()) {
            if (ServerCloneController.Instance != null && !ServerCloneController.Instance.hasClone(entry.getValue().tab, entry.getValue().name)) continue;
            CompoundNBT c = new CompoundNBT();
            c.func_74768_a("slot", entry.getKey().intValue());
            c.func_74768_a("tab", entry.getValue().tab);
            c.func_74778_a("name", entry.getValue().name);
            list.add((Object)c);
        }
        return list;
    }
}

