/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerSkinData {
    private boolean isSmallArms;
    private int body;
    private int bodyColor;
    private int hair;
    private int hairColor;
    private int face;
    private int eyesColor;
    private int leg;
    private int jacket;
    private int shoes;
    private List<Integer> peculiarities;
    private boolean isActive;
    private ResourceLocation cacheResLoc = null;
    private boolean hasChanged;
    private static boolean skinsNeedResync;

    public boolean isSmallArms() {
        return this.isSmallArms;
    }

    public PlayerSkinData setSmallArms(boolean smallArms) {
        this.isSmallArms = smallArms;
        this.markChanged();
        return this;
    }

    public String getGender() {
        return this.isSmallArms ? "female" : "male";
    }

    public int getBody() {
        return this.body;
    }

    public PlayerSkinData setBody(int body) {
        this.body = body;
        this.markChanged();
        return this;
    }

    public int getBodyColor() {
        return this.bodyColor;
    }

    public PlayerSkinData setBodyColor(int bodyColor) {
        this.bodyColor = bodyColor;
        this.markChanged();
        return this;
    }

    public int getHair() {
        return this.hair;
    }

    public PlayerSkinData setHair(int hair) {
        this.hair = hair;
        this.markChanged();
        return this;
    }

    public int getHairColor() {
        return this.hairColor;
    }

    public PlayerSkinData setHairColor(int hairColor) {
        this.hairColor = hairColor;
        this.markChanged();
        return this;
    }

    public int getFace() {
        return this.face;
    }

    public PlayerSkinData setFace(int face) {
        this.face = face;
        this.markChanged();
        return this;
    }

    public int getEyesColor() {
        return this.eyesColor;
    }

    public PlayerSkinData setEyesColor(int eyesColor) {
        this.eyesColor = eyesColor;
        this.markChanged();
        return this;
    }

    public int getLeg() {
        return this.leg;
    }

    public PlayerSkinData setLeg(int leg) {
        this.leg = leg;
        this.markChanged();
        return this;
    }

    public int getJacket() {
        return this.jacket;
    }

    public PlayerSkinData setJacket(int jacket) {
        this.jacket = jacket;
        this.markChanged();
        return this;
    }

    public int getShoes() {
        return this.shoes;
    }

    public PlayerSkinData setShoes(int shoes) {
        this.shoes = shoes;
        this.markChanged();
        return this;
    }

    public List<Integer> getPeculiarities() {
        return this.peculiarities;
    }

    public PlayerSkinData setPeculiarities(List<Integer> peculiarities) {
        this.peculiarities = peculiarities;
        this.markChanged();
        return this;
    }

    public void markChanged() {
        this.calculateResLoc();
        skinsNeedResync = true;
        this.hasChanged = true;
        this.isActive = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void markSynced() {
        this.hasChanged = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void calculateResLoc() {
        StringBuilder path = new StringBuilder("textures/entity/custom/");
        path.append(this.getGender()).append("_");
        path.append(this.getBody()).append("_");
        path.append(this.getBodyColor()).append("_");
        path.append(this.getHair()).append("_");
        path.append(this.getHairColor()).append("_");
        path.append(this.getFace()).append("_");
        path.append(this.getEyesColor()).append("_");
        path.append(this.getLeg()).append("_");
        path.append(this.getJacket()).append("_");
        path.append(this.getShoes());
        for (int id : this.peculiarities) {
            path.append("_").append(id);
        }
        path.append(".png");
        this.cacheResLoc = new ResourceLocation("customnpcs", path.toString());
    }

    public ResourceLocation getResLoc() {
        if (this.cacheResLoc == null) {
            this.calculateResLoc();
        }
        return this.cacheResLoc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getPartResLocByNumber(TextureManager textureManager, String name, int partNum) {
        ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + this.getGender() + "/" + name + "/" + partNum + ".png");
        textureManager.func_110577_a(loc);
        if (textureManager.func_229267_b_(loc) == null) {
            loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + this.getGender() + "/" + name + "/0.png");
            textureManager.func_110577_a(loc);
        }
        if (textureManager.func_229267_b_(loc) != null) {
            return loc;
        }
        return null;
    }

    public CompoundNBT saveNBTData(CompoundNBT tag) {
        tag.func_74757_a("isSmallArms", this.isSmallArms);
        tag.func_74768_a("body", this.body);
        tag.func_74768_a("bodyColor", this.bodyColor);
        tag.func_74768_a("hair", this.hair);
        tag.func_74768_a("hairColor", this.hairColor);
        tag.func_74768_a("face", this.face);
        tag.func_74768_a("eyesColor", this.eyesColor);
        tag.func_74768_a("leg", this.leg);
        tag.func_74768_a("jacket", this.jacket);
        tag.func_74768_a("shoes", this.shoes);
        tag.func_197646_b("peculiarities", this.peculiarities);
        tag.func_74757_a("isActive", this.isActive);
        return tag;
    }

    public void loadNBTData(CompoundNBT tag) {
        this.isSmallArms = tag.func_74767_n("isSmallArms");
        this.body = tag.func_74762_e("body");
        this.bodyColor = tag.func_74762_e("bodyColor");
        this.hair = tag.func_74762_e("hair");
        this.hairColor = tag.func_74762_e("hairColor");
        this.face = tag.func_74762_e("face");
        this.eyesColor = tag.func_74762_e("eyesColor");
        this.leg = tag.func_74762_e("leg");
        this.jacket = tag.func_74762_e("jacket");
        this.shoes = tag.func_74762_e("shoes");
        this.peculiarities = Arrays.stream(tag.func_74759_k("peculiarities")).boxed().collect(Collectors.toList());
        this.isActive = tag.func_74767_n("isActive");
    }

    public static boolean needsAnyResync() {
        return skinsNeedResync;
    }

    public static void resyncPerformed() {
        skinsNeedResync = false;
    }
}

