/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketPlayerMailSend
extends PacketServerBasic {
    private final CompoundNBT data;
    private final String username;

    public SPacketPlayerMailSend(String username, CompoundNBT data) {
        this.username = username;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    public static void encode(SPacketPlayerMailSend msg, PacketBuffer buf) {
        buf.func_180714_a(msg.username);
        buf.func_150786_a(msg.data);
    }

    public static SPacketPlayerMailSend decode(PacketBuffer buf) {
        return new SPacketPlayerMailSend(buf.func_150789_c(Short.MAX_VALUE), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        String username = PlayerDataController.instance.hasPlayer(this.username);
        if (username.isEmpty()) {
            NoppesUtilServer.sendGuiError((PlayerEntity)this.player, 0);
            return;
        }
        PlayerMail mail = new PlayerMail();
        String s = this.player.func_145748_c_().getString();
        if (!s.equals(this.player.func_200200_C_().getString())) {
            s = s + "(" + this.player.func_200200_C_().getString() + ")";
        }
        mail.readNBT(this.data);
        mail.sender = s;
        if (mail.subject.isEmpty()) {
            NoppesUtilServer.sendGuiError((PlayerEntity)this.player, 1);
            return;
        }
        mail.items = ((ContainerMail)this.player.field_71070_bA).mail.items;
        CompoundNBT comp = new CompoundNBT();
        comp.func_74778_a("username", username);
        NoppesUtilServer.sendGuiClose(this.player, 1, comp);
        this.player.func_71053_j();
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((PlayerEntity)this.player);
        if (npc != null && EventHooks.onNPCRole(npc, new RoleEvent.MailmanEvent((PlayerEntity)this.player, npc.wrappedNPC, mail))) {
            return;
        }
        PlayerDataController.instance.addPlayerMessage(this.player.func_184102_h(), username, mail);
    }
}

