/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.fml.ModList;
import noppes.npcs.schematics.Blueprint;

public class BlueprintUtil {
    public static CompoundNBT writeBlueprintToNBT(Blueprint schem) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74774_a("version", (byte)1);
        compound.func_74777_a("size_x", schem.getSizeX());
        compound.func_74777_a("size_y", schem.getSizeY());
        compound.func_74777_a("size_z", schem.getSizeZ());
        BlockState[] palette = schem.getPallete();
        ListNBT paletteTag = new ListNBT();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            paletteTag.add((Object)NBTUtil.func_190009_a((BlockState)palette[i]));
        }
        compound.func_218657_a("palette", (INBT)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        compound.func_74783_a("blocks", blockInt);
        ListNBT finishedTes = new ListNBT();
        CompoundNBT[] tes = schem.getTileEntities();
        for (int i = 0; i < tes.length; ++i) {
            finishedTes.add((Object)tes[i]);
        }
        compound.func_218657_a("tile_entities", (INBT)finishedTes);
        List<String> requiredMods = schem.getRequiredMods();
        ListNBT modsList = new ListNBT();
        for (int i = 0; i < requiredMods.size(); ++i) {
            modsList.add((Object)StringNBT.func_229705_a_((String)requiredMods.get(i)));
        }
        compound.func_218657_a("required_mods", (INBT)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            compound.func_74778_a("name", name);
        }
        if (architects != null) {
            ListNBT architectsTag = new ListNBT();
            for (String architect : architects) {
                architectsTag.add((Object)StringNBT.func_229705_a_((String)architect));
            }
            compound.func_218657_a("architects", (INBT)architectsTag);
        }
        return compound;
    }

    public static Blueprint readBlueprintFromNBT(CompoundNBT tag) {
        byte version = tag.func_74771_c("version");
        if (version == 1) {
            short sizeX = tag.func_74765_d("size_x");
            short sizeY = tag.func_74765_d("size_y");
            short sizeZ = tag.func_74765_d("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ListNBT modsList = tag.func_150295_c("required_mods", 8);
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(((StringNBT)modsList.get(i)).func_150285_a_());
                if (ModList.get().isLoaded((String)requiredMods.get(i))) continue;
                Logger.getGlobal().log(Level.WARNING, "Couldn't load Blueprint, the following mod is missing: " + (String)requiredMods.get(i));
                return null;
            }
            ListNBT paletteTag = tag.func_150295_c("palette", 10);
            short paletteSize = (short)paletteTag.size();
            BlockState[] palette = new BlockState[paletteSize];
            for (int i = 0; i < palette.length; i = (int)((short)(i + 1))) {
                palette[i] = NBTUtil.func_190008_d((CompoundNBT)paletteTag.func_150305_b(i));
            }
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.func_74759_k("blocks"), sizeX, sizeY, sizeZ);
            ListNBT teTag = tag.func_150295_c("tile_entities", 10);
            CompoundNBT[] tileEntities = new CompoundNBT[teTag.size()];
            for (int i = 0; i < tileEntities.length; i = (int)((short)(i + 1))) {
                tileEntities[i] = teTag.func_150305_b(i);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, paletteSize, palette, blocks, tileEntities, requiredMods);
            if (tag.func_74764_b("name")) {
                schem.setName(tag.func_74779_i("name"));
            }
            if (tag.func_74764_b("architects")) {
                ListNBT architectsTag = tag.func_150295_c("architects", 8);
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.func_150307_f(i);
                }
                schem.setArchitects(architects);
            }
            return schem;
        }
        return null;
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        int currentInt = 0;
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
            currentInt = 0;
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    public static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

