/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Direction;

public class ModelPlaneVcRenderer
extends ModelRenderer {
    private int xTexOffs;
    private int yTexOffs;

    public ModelPlaneVcRenderer(Model modelbase, int i, int j) {
        super(modelbase, i, j);
        this.xTexOffs = i;
        this.yTexOffs = j;
    }

    public ModelPlaneVcRenderer(int height, int width, int i, int j) {
        super(height, width, i, j);
        this.xTexOffs = i;
        this.yTexOffs = j;
    }

    public void addBackPlane(float f, float f1, float f2, int i, int j) {
        this.addPlane(f, f1, f2, i, j, 0, 1.0f, Direction.SOUTH);
    }

    public void addSidePlane(float f, float f1, float f2, int j, int k) {
        this.addPlane(f, f1, f2, 0, j, k, 1.0f, Direction.WEST);
    }

    public ModelPlaneVcRenderer addPlane(float f, float f1, float f2, int i, int j, Direction d) {
        if (d == Direction.DOWN || d == Direction.UP) {
            this.addPlane(f, f1, f2, i, 0, j, 1.0f, d);
        }
        if (d == Direction.EAST || d == Direction.WEST) {
            this.addPlane(f, f1, f2, 0, i, j, 1.0f, d);
        }
        if (d == Direction.SOUTH || d == Direction.NORTH) {
            this.addPlane(f, f1, f2, i, j, 0, 1.0f, d);
        }
        return this;
    }

    public ModelPlaneVcRenderer addTopPlane(float f, float f1, float f2, int i, int k) {
        return this.addTopPlane(f, f1, f2, i, k, 1.0f);
    }

    public ModelPlaneVcRenderer addTopPlane(float f, float f1, float f2, int i, int k, float scale) {
        this.addPlane(f, f1, f2, i, 0, k, scale, Direction.UP);
        return this;
    }

    public ModelPlaneVcRenderer addBottomPlane(float f, float f1, float f2, int i, int k) {
        return this.addBottomPlane(f, f1, f2, i, k, 1.0f);
    }

    public ModelPlaneVcRenderer addBottomPlane(float f, float f1, float f2, int i, int k, float scale) {
        this.addPlane(f, f1, f2, i, 0, k, scale, Direction.DOWN);
        return this;
    }

    public void addBackPlane(float f, float f1, float f2, int i, int j, float scale) {
        this.addPlane(f, f1, f2, i, j, 0, scale, Direction.SOUTH);
    }

    public void addSidePlane(float f, float f1, float f2, int j, int k, float scale) {
        this.addPlane(f, f1, f2, 0, j, k, scale, Direction.WEST);
    }

    public void addPlane(float x, float y, float z, int dx, int dy, int dz, float scale, Direction pos) {
        this.func_228300_a_(x, y, z, dx, dy, dz);
        float xx = x + (float)dx;
        float yy = y + (float)dy;
        float zz = z + (float)dz;
        xx *= scale;
        yy *= scale;
        zz *= scale;
        if (this.field_78809_i) {
            float var14 = xx;
            xx = x;
            x = var14;
        }
        ModelRenderer.PositionTextureVertex lvt_18_2_ = new ModelRenderer.PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        ModelRenderer.PositionTextureVertex lvt_19_1_ = new ModelRenderer.PositionTextureVertex(xx, y, z, 0.0f, 8.0f);
        ModelRenderer.PositionTextureVertex lvt_20_1_ = new ModelRenderer.PositionTextureVertex(xx, yy, z, 8.0f, 8.0f);
        ModelRenderer.PositionTextureVertex lvt_21_1_ = new ModelRenderer.PositionTextureVertex(x, yy, z, 8.0f, 0.0f);
        ModelRenderer.PositionTextureVertex lvt_22_1_ = new ModelRenderer.PositionTextureVertex(x, y, zz, 0.0f, 0.0f);
        ModelRenderer.PositionTextureVertex lvt_23_1_ = new ModelRenderer.PositionTextureVertex(xx, y, zz, 0.0f, 8.0f);
        ModelRenderer.PositionTextureVertex lvt_24_1_ = new ModelRenderer.PositionTextureVertex(xx, yy, zz, 8.0f, 8.0f);
        ModelRenderer.PositionTextureVertex lvt_25_1_ = new ModelRenderer.PositionTextureVertex(x, yy, zz, 8.0f, 0.0f);
        ModelRenderer.ModelBox box = (ModelRenderer.ModelBox)this.field_78804_l.get(this.field_78804_l.size() - 1);
        if (pos == Direction.EAST) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_23_1_, lvt_19_1_, lvt_20_1_, lvt_24_1_}, (float)this.xTexOffs, (float)this.yTexOffs, (float)(this.xTexOffs + dz), (float)(this.yTexOffs + dy), this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.WEST)};
        }
        if (pos == Direction.DOWN) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_23_1_, lvt_22_1_, lvt_18_2_, lvt_19_1_}, (float)this.xTexOffs, (float)this.yTexOffs, (float)(this.xTexOffs + dx), (float)(this.yTexOffs + dz), this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.DOWN)};
        }
        if (pos == Direction.NORTH) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_19_1_, lvt_18_2_, lvt_21_1_, lvt_20_1_}, (float)this.xTexOffs, (float)this.yTexOffs, (float)(this.xTexOffs + dy), (float)(this.yTexOffs + dx), this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.NORTH)};
        }
        if (pos == Direction.UP) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_20_1_, lvt_21_1_, lvt_25_1_, lvt_24_1_}, (float)(this.xTexOffs + dx), (float)(this.yTexOffs + dz), (float)this.xTexOffs, (float)this.yTexOffs, this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.UP)};
        }
        if (pos == Direction.WEST) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_18_2_, lvt_22_1_, lvt_25_1_, lvt_21_1_}, (float)this.xTexOffs, (float)this.yTexOffs, (float)(this.xTexOffs + dz), (float)(this.yTexOffs + dy), this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.WEST)};
        }
        if (pos == Direction.SOUTH) {
            box.field_78254_i = new ModelRenderer.TexturedQuad[]{new ModelRenderer.TexturedQuad(new ModelRenderer.PositionTextureVertex[]{lvt_22_1_, lvt_23_1_, lvt_24_1_, lvt_25_1_}, (float)this.xTexOffs, (float)this.yTexOffs, (float)(this.xTexOffs + dy), (float)(this.yTexOffs + dx), this.field_78801_a, this.field_78799_b, this.field_78809_i, Direction.SOUTH)};
        }
    }

    public ModelPlaneVcRenderer pos(float x, float y, float z) {
        this.field_78800_c = x;
        this.field_78797_d = y;
        this.field_78798_e = z;
        return this;
    }
}

