/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileBanner;

public class BlockBanner
extends ContainerBlock {
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_16;
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0));
    private final Block material;

    public BlockBanner(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.material = block;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)VCBlockStateProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileBanner tile;
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item.func_190926_b() || level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue()) {
            pos = pos.func_177977_b();
        }
        if ((tile = (TileBanner)level.func_175625_s(pos)).canEdit()) {
            return ActionResultType.FAIL;
        }
        if (!(item.func_77973_b() instanceof DyeItem)) {
            return ActionResultType.FAIL;
        }
        state = level.func_180495_p(pos);
        level.func_180501_a(pos, (BlockState)state.func_206870_a(VCBlockStateProperties.COLOR, (Comparable)DyeColor.getColor((ItemStack)item)), 3);
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VCBlockStateProperties.COLOR, ROTATION, VCBlockStateProperties.TOP});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        try {
            if (((Boolean)level.func_180495_p(pos).func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue()) {
                return AABB2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return AABB1;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader par1level, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (!level.func_175623_d(pos.func_177984_a())) {
            level.func_217377_a(pos, false);
        } else {
            int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 22.5f) + 0.5)) & 0xF;
            level.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)VCBlockStateProperties.TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)VCBlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot)), 2);
            level.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)VCBlockStateProperties.TOP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)VCBlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot)), 2);
            TileBanner tile = (TileBanner)level.func_175625_s(pos);
            tile.time = System.currentTimeMillis();
            if (level.field_72995_K) {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent("block.editIcon"), Util.field_240973_b_);
            }
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileBanner().setMaterial(this.material);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this) || !((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, newState, world, pos, pos2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.banner";
    }
}

