/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.CommonUtils;
import noppes.vc.VCBlocks;
import noppes.vc.VariedCommodities;
import noppes.vc.blocks.BlockBasicLightable;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileCampfire;

public class BlockCampfire
extends BlockBasicLightable {
    public static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;

    public BlockCampfire(boolean lit) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e).func_226896_b_(), lit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCampfire();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack item = player.func_184586_b(hand);
        if (item == null) {
            return ActionResultType.SUCCESS;
        }
        if ((item.func_77973_b() == Items.field_151145_ak || item.func_77973_b() == Items.field_151033_d) && this.unlitBlock() == this) {
            if (level.field_73012_v.nextInt(3) == 0 && !level.field_72995_K) {
                super.func_225533_a_(state, level, pos, player, hand, ray);
            }
            VariedCommodities.proxy.addParticle((ParticleType)ParticleTypes.field_197594_E, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0, 0.0, 0.0, 2.0f);
            if (item.func_77973_b() == Items.field_151145_ak) {
                CommonUtils.ConsumeItemStack(1, player);
            } else {
                item.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        if (item.func_77973_b() == Items.field_221548_A && this.litBlock() == this) {
            super.func_225533_a_(state, level, pos, player, hand, ray);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World level, BlockPos pos, Random rand) {
        if (state.func_177230_c() != VCBlocks.campfire) {
            return;
        }
        if (rand.nextInt(36) == 0) {
            level.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        TileCampfire tile = (TileCampfire)level.func_175625_s(pos);
        float xOffset = 0.5f;
        float yOffset = 0.7f;
        float zOffset = 0.5f;
        double d0 = (float)pos.func_177958_n() + xOffset;
        double d1 = (float)pos.func_177956_o() + yOffset;
        double d2 = (float)pos.func_177952_p() + zOffset;
        VariedCommodities.proxy.addParticle((ParticleType)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0, 1.0f);
        VariedCommodities.proxy.addParticle((ParticleType)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0, 3.0f);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
    }

    @Override
    public Block unlitBlock() {
        return VCBlocks.campfire_unlit;
    }

    @Override
    public Block litBlock() {
        return VCBlocks.campfire;
    }
}

