/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.BlockChair;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileCouchWood;

public class BlockCouchWood
extends BlockBasicContainer {
    public static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
    public static final EnumProperty<DyeColor> COLOR = VCBlockStateProperties.COLOR;
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_3;
    public static final BooleanProperty LEFT = VCBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = VCBlockStateProperties.RIGHT;
    private final Block material;

    public BlockCouchWood(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.material = block;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack item = player.func_184586_b(hand);
        if (item.func_190926_b() || !(item.func_77973_b() instanceof DyeItem)) {
            return BlockChair.MountBlock(level, pos, player);
        }
        level.func_180501_a(pos, (BlockState)state.func_206870_a(COLOR, (Comparable)DyeColor.getColor((ItemStack)item)), 3);
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.func_203425_a(oldState.func_177230_c())) {
            int rotation = (Integer)state.func_177229_b((Property)ROTATION);
            BlockPos lPos = BlockCouchWood.getLeftPos(state, pos);
            BlockPos rPos = BlockCouchWood.getRightPos(state, pos);
            BlockState lState = level.func_180495_p(lPos);
            BlockState rState = level.func_180495_p(rPos);
            state = (BlockState)((BlockState)state.func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(rotation == BlockCouchWood.getRotation((Block)this, lState)))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(rotation == BlockCouchWood.getRotation((Block)this, rState)));
            level.func_180501_a(pos, state, 3);
            if (lState.func_203425_a((Block)this) && state.func_177229_b((Property)LEFT) != lState.func_177229_b((Property)RIGHT)) {
                level.func_180501_a(lPos, (BlockState)lState.func_206870_a((Property)RIGHT, state.func_177229_b((Property)LEFT)), 3);
            }
            if (rState.func_203425_a((Block)this) && state.func_177229_b((Property)RIGHT) != rState.func_177229_b((Property)LEFT)) {
                level.func_180501_a(rPos, (BlockState)rState.func_206870_a((Property)LEFT, state.func_177229_b((Property)RIGHT)), 3);
            }
        }
    }

    public static BlockPos getRightPos(BlockState state, BlockPos pos) {
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (rotation == 0) {
            return pos.func_177974_f();
        }
        if (rotation == 1) {
            return pos.func_177968_d();
        }
        if (rotation == 2) {
            return pos.func_177976_e();
        }
        return pos.func_177978_c();
    }

    public static BlockPos getLeftPos(BlockState state, BlockPos pos) {
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (rotation == 0) {
            return pos.func_177976_e();
        }
        if (rotation == 1) {
            return pos.func_177978_c();
        }
        if (rotation == 2) {
            return pos.func_177974_f();
        }
        return pos.func_177968_d();
    }

    public static int getRotation(Block b, BlockState state) {
        if (!state.func_203425_a(b)) {
            return -1;
        }
        return (Integer)state.func_177229_b((Property)ROTATION);
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 90.0f) + 0.5)) & 3;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 3);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{COLOR, ROTATION, LEFT, RIGHT});
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos nPos;
        if (state.func_203425_a(newState.func_177230_c())) {
            return;
        }
        if (((Boolean)state.func_177229_b((Property)LEFT)).booleanValue()) {
            nPos = BlockCouchWood.getLeftPos(state, pos);
            level.func_180501_a(nPos, (BlockState)level.func_180495_p(nPos).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (((Boolean)state.func_177229_b((Property)RIGHT)).booleanValue()) {
            nPos = BlockCouchWood.getRightPos(state, pos);
            level.func_180501_a(nPos, (BlockState)level.func_180495_p(nPos).func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCouchWood().setMaterial(this.material);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.couch_wood";
    }
}

