/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileTallLamp;

public class BlockTallLamp
extends BlockBasicContainer {
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0));
    public static final BooleanProperty IS_TOP = VCBlockStateProperties.TOP;
    private static final EnumProperty<DyeColor> COLOR = VCBlockStateProperties.COLOR;
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;
    private final Block material;

    public BlockTallLamp(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_235838_a_(state -> 15).func_226896_b_());
        this.material = block;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null || !(item.func_77973_b() instanceof DyeItem)) {
            return ActionResultType.PASS;
        }
        if (((Boolean)state.func_177229_b((Property)IS_TOP)).booleanValue()) {
            pos = pos.func_177977_b();
            state = level.func_180495_p(pos);
        }
        level.func_180501_a(pos, (BlockState)state.func_206870_a(COLOR, (Comparable)DyeColor.getColor((ItemStack)item)), 3);
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{IS_TOP, COLOR, ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (!level.func_175623_d(pos.func_177984_a())) {
            level.func_217377_a(pos, false);
        } else {
            int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
            level.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
            level.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this) || !((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, newState, world, pos, pos2);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        try {
            if (((Boolean)level.func_180495_p(pos).func_177229_b((Property)IS_TOP)).booleanValue()) {
                return AABB2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return AABB1;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileTallLamp().setMaterial(this.material);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.tall_lamp";
    }
}

