/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileBigSign;
import noppes.vc.blocks.tiles.TileTombstone;
import noppes.vc.constants.GuiType;
import noppes.vc.packets.Packets;
import noppes.vc.packets.client.PacketGui;

public class BlockTombstone
extends BlockBasicContainer {
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_7;
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, 1.0, (double)0.7f));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));
    public static final VoxelShape AABB3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, 1.0, 1.0));
    private final int type;

    public BlockTombstone(int type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        this.type = type;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 45.0f) + 0.5)) & 7;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
        if (entity instanceof ServerPlayerEntity && !level.field_72995_K && this.type < 2) {
            Packets.send((ServerPlayerEntity)entity, new PacketGui(GuiType.BIG_SIGN, pos));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem.func_77973_b().getRegistryName().toString().equals("customnpcs:npcwand")) {
            TileBigSign tile = (TileBigSign)level.func_175625_s(pos);
            if (this.type >= 2) {
                return ActionResultType.PASS;
            }
            tile.canEdit = true;
            Packets.send((ServerPlayerEntity)player, new PacketGui(GuiType.BIG_SIGN, pos));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (rotation % 4 == 0) {
            return AABB1;
        }
        if (rotation % 4 == 2) {
            return AABB3;
        }
        return AABB2;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileTombstone().setType(this.type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.tombstone";
    }
}

