/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileWallBanner;

public class BlockWallBanner
extends BlockBasicContainer {
    public int renderId = -1;
    public static final VoxelShape AABB0 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, 1.0, 1.0));
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, 1.0, 1.0));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.3f));
    public static final VoxelShape AABB3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, 1.0, 1.0));
    private final Block block;

    public BlockWallBanner(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_200942_a());
        this.block = block;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VCBlockStateProperties.COLOR});
        builder.func_206894_a(new Property[]{VCBlockStateProperties.ROTATION_0_3});
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item.func_190926_b() || level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileWallBanner tile = (TileWallBanner)level.func_175625_s(pos);
        if (tile.canEdit()) {
            return ActionResultType.PASS;
        }
        if (!(item.func_77973_b() instanceof DyeItem)) {
            return ActionResultType.FAIL;
        }
        level.func_180501_a(pos, (BlockState)state.func_206870_a(VCBlockStateProperties.COLOR, (Comparable)DyeColor.getColor((ItemStack)item)), 3);
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        int rotation = (Integer)state.func_177229_b((Property)VCBlockStateProperties.ROTATION_0_3);
        if (rotation == 0) {
            return AABB0;
        }
        if (rotation == 2) {
            return AABB2;
        }
        if (rotation == 3) {
            return AABB3;
        }
        if (rotation == 1) {
            return AABB1;
        }
        return super.func_220053_a(state, level, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader par1level, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 90.0f) + 0.5)) & 3;
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)VCBlockStateProperties.ROTATION_0_3, (Comparable)Integer.valueOf(rot)), 2);
        TileWallBanner tile = (TileWallBanner)level.func_175625_s(pos);
        tile.time = System.currentTimeMillis();
        if (entity instanceof PlayerEntity && level.field_72995_K) {
            ((PlayerEntity)entity).func_145747_a((ITextComponent)new TranslationTextComponent("block.editIcon"), Util.field_240973_b_);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileWallBanner().setMaterial(this.block);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.wall_banner";
    }
}

