/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.blocks.BlockBasicTrigger;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileBasicContainer;
import noppes.vc.blocks.tiles.TileWeaponRack;

public class BlockWeaponRack
extends BlockBasicTrigger {
    public static final BooleanProperty IS_TOP = VCBlockStateProperties.TOP;
    public static final IntegerProperty ROTATION = VCBlockStateProperties.ROTATION_0_3;
    public static final VoxelShape AABB0 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, (double)1.8f, 1.0));
    public static final VoxelShape AABB1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, (double)1.8f, 1.0));
    public static final VoxelShape AABB2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)1.8f, (double)0.3f));
    public static final VoxelShape AABB3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, (double)1.8f, 1.0));
    public static final VoxelShape AABBT0 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, -1.0, (double)0.7f, 1.0, (double)0.8f, 1.0));
    public static final VoxelShape AABBT1 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, -1.0, 0.0, (double)0.3f, (double)0.8f, 1.0));
    public static final VoxelShape AABBT2 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, (double)0.8f, (double)0.3f));
    public static final VoxelShape AABBT3 = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.7f, -1.0, 0.0, 1.0, (double)0.8f, 1.0));
    private final Block material;

    public BlockWeaponRack(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.material = block;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (level.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)IS_TOP)).booleanValue()) {
            pos = pos.func_177977_b();
            state = level.func_180495_p(pos);
        }
        TileWeaponRack tile = (TileWeaponRack)level.func_175625_s(pos);
        double hit = ray.func_216347_e().field_72450_a - (double)pos.func_177958_n();
        int rotation = (Integer)state.func_177229_b((Property)ROTATION);
        if (rotation == 2) {
            hit = 1.0 - (ray.func_216347_e().field_72450_a - (double)pos.func_177958_n());
        }
        if (rotation == 3) {
            hit = 1.0 - (ray.func_216347_e().field_72449_c - (double)pos.func_177952_p());
        }
        if (rotation == 1) {
            hit = ray.func_216347_e().field_72449_c - (double)pos.func_177952_p();
        }
        int selected = 2 - (int)(hit / 0.34);
        ItemStack weapon = tile.func_70301_a(selected);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item.func_190926_b() && !weapon.func_190926_b()) {
            tile.func_70299_a(selected, ItemStack.field_190927_a);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, weapon);
            tile.func_70296_d();
            level.func_184138_a(pos, state, state, 3);
            this.updateSurrounding(level, pos);
        } else {
            if (item.func_190926_b() || item.func_77973_b() instanceof BlockItem) {
                return ActionResultType.SUCCESS;
            }
            if (!item.func_190926_b() && weapon.func_190926_b()) {
                tile.func_70299_a(selected, item);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                tile.func_70296_d();
                level.func_184138_a(pos, state, state, 3);
                this.updateSurrounding(level, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{IS_TOP});
        builder.func_206894_a(new Property[]{ROTATION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (!level.func_175623_d(pos.func_177984_a())) {
            level.func_217377_a(pos, false);
        } else {
            int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z / 90.0f) + 0.5)) & 3;
            level.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
            level.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot)), 2);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        int rotation;
        boolean isTop = (Boolean)state.func_177229_b((Property)IS_TOP);
        if (isTop) {
            pos = pos.func_177977_b();
        }
        if ((rotation = ((Integer)state.func_177229_b((Property)ROTATION)).intValue()) == 0) {
            return isTop ? AABBT0 : AABB0;
        }
        if (rotation == 2) {
            return isTop ? AABBT2 : AABB2;
        }
        if (rotation == 3) {
            return isTop ? AABBT3 : AABB3;
        }
        if (rotation == 1) {
            return isTop ? AABBT1 : AABB1;
        }
        return super.func_220053_a(state, level, pos, context);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileWeaponRack().setMaterial(this.material);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this) || !((Boolean)state.func_177229_b((Property)VCBlockStateProperties.TOP)).booleanValue() && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, newState, world, pos, pos2);
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        TileBasicContainer tile = (TileBasicContainer)level.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        tile.dropItems(level, pos);
        level.func_175666_e(pos, state.func_177230_c());
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_149739_a() {
        return "block.variedcommodities.weapon_rack";
    }
}

