/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import noppes.vc.blocks.BlockShelf;
import noppes.vc.blocks.VCBlockStateProperties;
import noppes.vc.blocks.tiles.TileShelf;
import noppes.vc.client.models.ModelShelf;
import noppes.vc.client.renderer.BlockRendererBasic;

public class BlockShelfRenderer
extends BlockRendererBasic<TileShelf> {
    private final ModelShelf model = new ModelShelf();

    public BlockShelfRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileShelf tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        boolean isTop = (Boolean)tile.get(BlockShelf.TOP);
        matrixStack.func_227861_a_(0.5, isTop ? 1.5 : (double)1.1f, 0.5);
        boolean drawLeft = true;
        boolean drawRight = true;
        if (tile.func_174877_v() != BlockPos.field_177992_a) {
            BlockPos pos = tile.func_174877_v();
            int rotation = (Integer)tile.get(VCBlockStateProperties.ROTATION_0_3);
            if (rotation == 3) {
                drawLeft = this.shouldDraw(tile.func_145831_w(), pos.func_177968_d(), 3);
                drawRight = this.shouldDraw(tile.func_145831_w(), pos.func_177978_c(), 3);
            } else if (rotation == 1) {
                drawLeft = this.shouldDraw(tile.func_145831_w(), pos.func_177978_c(), 1);
                drawRight = this.shouldDraw(tile.func_145831_w(), pos.func_177968_d(), 1);
            } else if (rotation == 0) {
                drawLeft = this.shouldDraw(tile.func_145831_w(), pos.func_177974_f(), 0);
                drawRight = this.shouldDraw(tile.func_145831_w(), pos.func_177976_e(), 0);
            } else if (rotation == 2) {
                drawLeft = this.shouldDraw(tile.func_145831_w(), pos.func_177976_e(), 2);
                drawRight = this.shouldDraw(tile.func_145831_w(), pos.func_177974_f(), 2);
            }
        }
        this.model.SupportLeft1.field_78806_j = this.model.SupportLeft2.field_78806_j = drawLeft;
        this.model.SupportRight1.field_78806_j = this.model.SupportRight2.field_78806_j = drawRight;
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(90 * (Integer)tile.get(BlockShelf.ROTATION))));
        this.model.func_225598_a_(matrixStack, buffer.getBuffer(BlockShelfRenderer.getMaterialType(tile.material)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    private boolean shouldDraw(World level, BlockPos pos, int rotation) {
        TileEntity tile = level.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileShelf)) {
            return true;
        }
        return (Integer)((TileShelf)tile).get(VCBlockStateProperties.ROTATION_0_3) != rotation;
    }
}

