/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.constants;

import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.VCItems;

public enum VCArmorMaterial implements IArmorMaterial
{
    BRONZE("leather", 7, new int[]{2, 5, 6, 2}, 20, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{VCItems.ingot_bronze})),
    MITHRIL("chainmail", 40, new int[]{3, 6, 8, 3}, 20, SoundEvents.field_187725_r, 2.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{VCItems.ingot_mithril})),
    EMERALD("iron", 35, new int[]{3, 6, 8, 3}, 5, SoundEvents.field_187716_o, 2.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151166_bC}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final LazyValue<Ingredient> repairMaterial;

    private VCArmorMaterial(String nameIn, int p_i48533_4_, int[] p_i48533_5_, int p_i48533_6_, SoundEvent p_i48533_7_, float p_i48533_8_, Supplier<Ingredient> p_i48533_9_) {
        this.name = nameIn;
        this.maxDamageFactor = p_i48533_4_;
        this.damageReductionAmountArray = p_i48533_5_;
        this.enchantability = p_i48533_6_;
        this.soundEvent = p_i48533_7_;
        this.toughness = p_i48533_8_;
        this.repairMaterial = new LazyValue(p_i48533_9_);
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * this.maxDamageFactor;
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.damageReductionAmountArray[slotIn.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return 0.0f;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

