/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.items;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import noppes.vc.VCTabs;

public class ItemBasic
extends Item {
    private boolean damageAble = true;

    public ItemBasic() {
        this(new Item.Properties().func_200916_a(VCTabs.ITEMS));
    }

    public ItemBasic(ItemGroup group) {
        this(new Item.Properties().func_200916_a(group));
    }

    public ItemBasic(Item.Properties properties) {
        super(properties);
    }

    public void setUnDamageable() {
        this.damageAble = false;
    }

    public Item register(String name) {
        this.setRegistryName(new ResourceLocation("variedcommodities", name));
        return this;
    }

    public static void playSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        if (entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), sound, SoundCategory.NEUTRAL, volume, pitch);
        } else if (sound != null && sound.getRegistryName() != null) {
            SPlaySoundPacket packet = new SPlaySoundPacket(sound.getRegistryName(), SoundCategory.NEUTRAL, entity.func_213303_ch(), volume, pitch);
            entity.func_184102_h().func_184103_al().func_148543_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, entity.field_70170_p.func_234923_W_(), (IPacket)packet);
        }
    }

    public boolean func_77644_a(ItemStack item, LivingEntity target, LivingEntity owner) {
        if (target.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (this.damageAble) {
            item.func_222118_a(1, owner, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean hasItem(PlayerEntity player, Item item) {
        return this.getItemStack(player, item) != null;
    }

    public boolean consumeItem(PlayerEntity player, Item item) {
        ItemStack itemstack = this.getItemStack(player, item);
        if (itemstack == null || itemstack.func_190926_b()) {
            return false;
        }
        itemstack.func_190918_g(1);
        if (itemstack.func_190916_E() == 0) {
            player.field_71071_by.func_184437_d(itemstack);
        }
        return true;
    }

    private ItemStack getItemStack(PlayerEntity player, Item item) {
        if (player.func_184586_b(Hand.OFF_HAND).func_77973_b() == item) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == item) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack == null || itemstack.func_77973_b() != item) continue;
            return itemstack;
        }
        return null;
    }
}

