/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.packets.server;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import noppes.vc.CommonUtils;
import noppes.vc.blocks.tiles.TileBook;

public class SPacketBookSave {
    public final BlockPos pos;
    public final boolean sign;
    public final ItemStack item;

    public SPacketBookSave(BlockPos pos, boolean sign, ItemStack item) {
        this.pos = pos;
        this.sign = sign;
        this.item = item;
    }

    public static void encode(SPacketBookSave msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeBoolean(msg.sign);
        buf.func_150788_a(msg.item);
    }

    public static SPacketBookSave decode(PacketBuffer buf) {
        return new SPacketBookSave(buf.func_179259_c(), buf.readBoolean(), buf.func_150791_c());
    }

    public static void handle(SPacketBookSave msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity tileentity = player.field_70170_p.func_175625_s(msg.pos);
            if (!(tileentity instanceof TileBook)) {
                return;
            }
            TileBook tile = (TileBook)tileentity;
            if (tile.book.func_77973_b() == Items.field_151164_bB) {
                return;
            }
            ItemStack book = msg.item;
            if (book.func_190926_b() || !WritableBookItem.func_150930_a((CompoundNBT)book.func_77978_p())) {
                return;
            }
            if (!msg.sign) {
                tile.book.func_77983_a("pages", (INBT)book.func_77978_p().func_150295_c("pages", 8));
            } else {
                tile.book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)player.func_146103_bH().getName()));
                tile.book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)book.func_77978_p().func_74779_i("title")));
                tile.book.func_77983_a("pages", (INBT)book.func_77978_p().func_150295_c("pages", 8));
                tile.book = CommonUtils.ChangeItemStack(tile.book, Items.field_151164_bB);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

