/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider {
    public ArmourerBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createBlockEntity(IBlockReader level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.ARMOURER.get()).create(level, blockPos, blockState);
    }

    @Override
    protected ActionResultType useWithoutItem(BlockState blockState, World level, BlockPos blockPos, PlayerEntity player, BlockRayTraceResult blockHitResult) {
        return ((IMenuType)ModMenuTypes.ARMOURER.get()).openMenu(player, level.func_175625_s(blockPos));
    }

    public BlockState func_185499_a(BlockState state, Rotation p_185499_2_) {
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror p_185471_2_) {
        return state;
    }

    public void func_180633_a(World level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(level, blockPos, blockState, livingEntity, itemStack);
        this.applyTitleEntity(level, blockPos, te -> te.onPlace(level, blockPos, blockState, livingEntity));
    }

    public void func_196243_a(BlockState blockState, World level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        this.applyTitleEntity(level, blockPos, te -> te.onRemove(level, blockPos, te.func_195044_w()));
        super.func_196243_a(blockState, level, blockPos, blockState2, bl);
    }

    private void applyTitleEntity(World level, BlockPos pos, Consumer<ArmourerBlockEntity> consumer) {
        TileEntity tileEntity = level.func_175625_s(pos);
        if (tileEntity instanceof ArmourerBlockEntity) {
            ArmourerBlockEntity blockEntity = (ArmourerBlockEntity)tileEntity;
            consumer.accept(blockEntity);
        }
    }
}

