/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ArmourerMenu
extends AbstractBlockEntityMenu<ArmourerBlockEntity> {
    private final Inventory inventory = new Inventory(4);
    private Group group = null;

    public ArmourerMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IGlobalPos access) {
        super((ContainerType)menuType, block, containerId, access);
        this.addPlayerSlots((IInventory)playerInventory, 8, 142, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addCustomSlot((IInventory)this.inventory, 0, 64, 21);
        this.addCustomSlot((IInventory)this.inventory, 1, 147, 21);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.clearContainer(player, (IInventory)this.inventory);
    }

    public boolean shouldLoadArmourItem(PlayerEntity player) {
        ItemStack stackInput = this.inventory.func_70301_a(0);
        ItemStack stackOutput = this.inventory.func_70301_a(1);
        if (stackInput.func_190926_b() || !stackOutput.func_190926_b()) {
            return false;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        return !descriptor.isEmpty();
    }

    public boolean shouldSaveArmourItem(PlayerEntity player) {
        ItemStack stackInput = this.inventory.func_70301_a(0);
        ItemStack stackOutput = this.inventory.func_70301_a(1);
        if (player.func_184812_l_() && stackInput.func_190926_b()) {
            stackInput = new ItemStack((IItemProvider)ModItems.SKIN_TEMPLATE.get());
        }
        return !stackInput.func_190926_b() && stackOutput.func_190926_b();
    }

    public void saveArmourItem(PlayerEntity player, GameProfile profile, String customName, String tags) {
        if (!this.shouldSaveArmourItem(player)) {
            return;
        }
        if (((ArmourerBlockEntity)this.blockEntity).func_145831_w() == null || ((ArmourerBlockEntity)this.blockEntity).func_145831_w().func_201670_d()) {
            return;
        }
        try {
            ItemStack stackInput = this.inventory.func_70301_a(0);
            SkinProperties skinProps = ((ArmourerBlockEntity)this.blockEntity).skinProperties().copy();
            skinProps.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProps.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            if (customName != null) {
                skinProps.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            }
            World level = ((ArmourerBlockEntity)this.blockEntity).func_145831_w();
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            Skin skin = WorldUtils.saveSkinFromWorld(level, transform, skinProps, ((ArmourerBlockEntity)this.blockEntity).skinType(), ((ArmourerBlockEntity)this.blockEntity).paintData());
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
            if (!player.func_184812_l_()) {
                stackInput.func_190918_g(1);
            }
            this.inventory.func_70299_a(1, descriptor.asItemStack());
        }
        catch (TranslatableException exception) {
            SystemMessageProvider.sendSystemMessage(player, exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadArmourItem(PlayerEntity player) {
        if (((ArmourerBlockEntity)this.blockEntity).func_145831_w() == null || ((ArmourerBlockEntity)this.blockEntity).func_145831_w().func_201670_d()) {
            return;
        }
        ItemStack stackInput = this.inventory.func_70301_a(0);
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        if (!this.shouldLoadArmourItem(player)) {
            return;
        }
        try {
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.identifier());
            if (skin == null) {
                throw SkinLoadException.Type.NOT_FOUND.build("notFound", new Object[0]);
            }
            if (skin.type() != ((ArmourerBlockEntity)this.blockEntity).skinType()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_TYPE.build("notSupportType", new Object[0]);
            }
            if (!skin.isBasicOnly()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_CONTENT.build("notSupportContent", new Object[0]);
            }
            if (!skin.settings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            ((ArmourerBlockEntity)this.blockEntity).setSkinProperties(skin.properties());
            ((ArmourerBlockEntity)this.blockEntity).setPaintData(skin.paintData());
            CubeChangesCollector collector = new CubeChangesCollector(((ArmourerBlockEntity)this.blockEntity).func_145831_w());
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            WorldUtils.loadSkinIntoWorld(collector, transform, skin);
            collector.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.load", new Object[0]), player);
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
            this.inventory.func_70299_a(1, stackInput);
        }
        catch (TranslatableException exception) {
            SystemMessageProvider.sendSystemMessage(player, exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    protected void addCustomSlot(IInventory inventory, final int slot, int x, int y) {
        this.func_75146_a(new GroupSlot(inventory, slot, x, y){

            public boolean func_75214_a(ItemStack itemStack) {
                if (slot == 0) {
                    if (Fix16.is(itemStack, (Item)ModItems.SKIN_TEMPLATE.get())) {
                        return true;
                    }
                    return !SkinDescriptor.of(itemStack).isEmpty();
                }
                return false;
            }
        });
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public boolean shouldRenderInventory() {
        return this.group == Group.MAIN;
    }

    public static enum Group {
        MAIN,
        SKIN,
        DISPLAY,
        BLOCK;

    }

    public class GroupSlot
    extends Slot {
        public GroupSlot(IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean func_111238_b() {
            return ArmourerMenu.this.shouldRenderInventory();
        }
    }
}

