/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPoseStackImpl {
    protected static final ObjectPool<OpenPoseStack> REUSABLE_QUEUE = ObjectPool.create(OpenPoseStack::new);
    private static final AbstractMatrix3f CONVERTER_MAT3 = new AbstractMatrix3f(new Matrix3f());
    private static final AbstractMatrix4f CONVERTER_MAT4 = new AbstractMatrix4f(new Matrix4f());
    private static final Quaternion CONVERTER_QUAT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private static final FloatBuffer BUFFER3x3 = MatrixUtils.createFloatBuffer(9);
    private static final FloatBuffer BUFFER4x4 = MatrixUtils.createFloatBuffer(16);

    public static Matrix3f convertMatrix(IMatrix3f mat) {
        AbstractMatrix3f newValue = Objects.safeCast(mat, AbstractMatrix3f.class);
        if (newValue != null) {
            return newValue.mat;
        }
        mat.store(BUFFER3x3);
        CONVERTER_MAT3.load(BUFFER3x3);
        return CONVERTER_MAT3.mat;
    }

    public static Matrix4f convertMatrix(IMatrix4f mat) {
        AbstractMatrix4f newValue = Objects.safeCast(mat, AbstractMatrix4f.class);
        if (newValue != null) {
            return newValue.mat;
        }
        mat.store(BUFFER4x4);
        CONVERTER_MAT4.load(BUFFER4x4);
        return CONVERTER_MAT4.mat;
    }

    public static Quaternion convertQuaternion(IQuaternionf q) {
        CONVERTER_QUAT.func_227066_a_(q.x(), q.y(), q.z(), q.w());
        return CONVERTER_QUAT;
    }

    public static Quaternion copyQuaternion(IQuaternionf q) {
        return new Quaternion(q.x(), q.y(), q.z(), q.w());
    }

    public static class AbstractMatrix3f
    implements IMatrix3f {
        private final Matrix3f mat;

        public AbstractMatrix3f(Matrix3f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.field_226097_a_ = buffer.get(this.bufferIndex(0, 0));
            this.mat.field_226098_b_ = buffer.get(this.bufferIndex(0, 1));
            this.mat.field_226099_c_ = buffer.get(this.bufferIndex(0, 2));
            this.mat.field_226100_d_ = buffer.get(this.bufferIndex(1, 0));
            this.mat.field_226101_e_ = buffer.get(this.bufferIndex(1, 1));
            this.mat.field_226102_f_ = buffer.get(this.bufferIndex(1, 2));
            this.mat.field_226103_g_ = buffer.get(this.bufferIndex(2, 0));
            this.mat.field_226104_h_ = buffer.get(this.bufferIndex(2, 1));
            this.mat.field_226105_i_ = buffer.get(this.bufferIndex(2, 2));
        }

        @Override
        public void store(FloatBuffer buffer) {
            buffer.put(this.bufferIndex(0, 0), this.mat.field_226097_a_);
            buffer.put(this.bufferIndex(0, 1), this.mat.field_226098_b_);
            buffer.put(this.bufferIndex(0, 2), this.mat.field_226099_c_);
            buffer.put(this.bufferIndex(1, 0), this.mat.field_226100_d_);
            buffer.put(this.bufferIndex(1, 1), this.mat.field_226101_e_);
            buffer.put(this.bufferIndex(1, 2), this.mat.field_226102_f_);
            buffer.put(this.bufferIndex(2, 0), this.mat.field_226103_g_);
            buffer.put(this.bufferIndex(2, 1), this.mat.field_226104_h_);
            buffer.put(this.bufferIndex(2, 2), this.mat.field_226105_i_);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.func_226118_b_(Matrix3f.func_226117_b_((float)x, (float)y, (float)z));
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.func_226115_a_(AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix3f matrix) {
            matrix.store(BUFFER3x3);
            this.load(BUFFER3x3);
        }

        public void set(IMatrix4f matrix) {
            FloatBuffer buffer = BUFFER4x4;
            matrix.store(buffer);
            this.mat.field_226097_a_ = buffer.get(this.bufferIndex4(0, 0));
            this.mat.field_226098_b_ = buffer.get(this.bufferIndex4(0, 1));
            this.mat.field_226099_c_ = buffer.get(this.bufferIndex4(0, 2));
            this.mat.field_226100_d_ = buffer.get(this.bufferIndex4(1, 0));
            this.mat.field_226101_e_ = buffer.get(this.bufferIndex4(1, 1));
            this.mat.field_226102_f_ = buffer.get(this.bufferIndex4(1, 2));
            this.mat.field_226103_g_ = buffer.get(this.bufferIndex4(2, 0));
            this.mat.field_226104_h_ = buffer.get(this.bufferIndex4(2, 1));
            this.mat.field_226105_i_ = buffer.get(this.bufferIndex4(2, 2));
        }

        @Override
        public void multiply(IMatrix3f matrix) {
            this.mat.func_226118_b_(AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector3f vec = new Vector3f(values[0], values[1], values[2]);
            vec.func_229188_a_(this.mat);
            values[0] = vec.func_195899_a();
            values[1] = vec.func_195900_b();
            values[2] = vec.func_195902_c();
        }

        @Override
        public void invert() {
            this.mat.func_226123_f_();
        }

        @Override
        public void transpose() {
            this.mat.func_226110_a_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix3f)) {
                return false;
            }
            AbstractMatrix3f that = (AbstractMatrix3f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        private int bufferIndex(int i, int j) {
            return j * 3 + i;
        }

        private int bufferIndex4(int i, int j) {
            return j * 4 + i;
        }
    }

    public static class AbstractMatrix4f
    implements IMatrix4f {
        private final Matrix4f mat;

        public AbstractMatrix4f(Matrix4f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.field_226575_a_ = buffer.get(this.bufferIndex(0, 0));
            this.mat.field_226576_b_ = buffer.get(this.bufferIndex(0, 1));
            this.mat.field_226577_c_ = buffer.get(this.bufferIndex(0, 2));
            this.mat.field_226578_d_ = buffer.get(this.bufferIndex(0, 3));
            this.mat.field_226579_e_ = buffer.get(this.bufferIndex(1, 0));
            this.mat.field_226580_f_ = buffer.get(this.bufferIndex(1, 1));
            this.mat.field_226581_g_ = buffer.get(this.bufferIndex(1, 2));
            this.mat.field_226582_h_ = buffer.get(this.bufferIndex(1, 3));
            this.mat.field_226583_i_ = buffer.get(this.bufferIndex(2, 0));
            this.mat.field_226584_j_ = buffer.get(this.bufferIndex(2, 1));
            this.mat.field_226585_k_ = buffer.get(this.bufferIndex(2, 2));
            this.mat.field_226586_l_ = buffer.get(this.bufferIndex(2, 3));
            this.mat.field_226587_m_ = buffer.get(this.bufferIndex(3, 0));
            this.mat.field_226588_n_ = buffer.get(this.bufferIndex(3, 1));
            this.mat.field_226589_o_ = buffer.get(this.bufferIndex(3, 2));
            this.mat.field_226590_p_ = buffer.get(this.bufferIndex(3, 3));
        }

        @Override
        public void store(FloatBuffer buffer) {
            buffer.put(this.bufferIndex(0, 0), this.mat.field_226575_a_);
            buffer.put(this.bufferIndex(0, 1), this.mat.field_226576_b_);
            buffer.put(this.bufferIndex(0, 2), this.mat.field_226577_c_);
            buffer.put(this.bufferIndex(0, 3), this.mat.field_226578_d_);
            buffer.put(this.bufferIndex(1, 0), this.mat.field_226579_e_);
            buffer.put(this.bufferIndex(1, 1), this.mat.field_226580_f_);
            buffer.put(this.bufferIndex(1, 2), this.mat.field_226581_g_);
            buffer.put(this.bufferIndex(1, 3), this.mat.field_226582_h_);
            buffer.put(this.bufferIndex(2, 0), this.mat.field_226583_i_);
            buffer.put(this.bufferIndex(2, 1), this.mat.field_226584_j_);
            buffer.put(this.bufferIndex(2, 2), this.mat.field_226585_k_);
            buffer.put(this.bufferIndex(2, 3), this.mat.field_226586_l_);
            buffer.put(this.bufferIndex(3, 0), this.mat.field_226587_m_);
            buffer.put(this.bufferIndex(3, 1), this.mat.field_226588_n_);
            buffer.put(this.bufferIndex(3, 2), this.mat.field_226589_o_);
            buffer.put(this.bufferIndex(3, 3), this.mat.field_226590_p_);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.func_226595_a_(Matrix4f.func_226593_a_((float)x, (float)y, (float)z));
        }

        @Override
        public void translate(float x, float y, float z) {
            this.mat.func_226597_a_(new Vector3f(x, y, z));
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.func_226596_a_(AbstractPoseStackImpl.convertQuaternion(q));
        }

        @Override
        public void set(IMatrix4f matrix) {
            matrix.store(BUFFER4x4);
            this.load(BUFFER4x4);
        }

        @Override
        public void multiply(IMatrix4f matrix) {
            this.mat.func_226595_a_(AbstractPoseStackImpl.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector4f vec = new Vector4f(values[0], values[1], values[2], values[3]);
            vec.func_229372_a_(this.mat);
            values[0] = vec.func_195910_a();
            values[1] = vec.func_195913_b();
            values[2] = vec.func_195914_c();
            values[3] = vec.func_195915_d();
        }

        @Override
        public void invert() {
            this.mat.func_226600_c_();
        }

        @Override
        public void transpose() {
            this.mat.func_226602_e_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMatrix4f)) {
                return false;
            }
            AbstractMatrix4f that = (AbstractMatrix4f)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        private int bufferIndex(int i, int j) {
            return j * 4 + i;
        }
    }
}

