/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.core.client.shader.ShaderContext;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class AbstractRenderTypeImpl
extends RenderType {
    private static final RenderState.TexturingState COLORS_OFFSET = new RenderState.TexturingState("aw_offset_ov", () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)AbstractPoseStack.convertMatrix(ShaderContext.getInstance().textureMatrix()));
        RenderSystem.matrixMode((int)5888);
    }, () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    private static final RenderState.TexturingState OR_REVERSE = new RenderState.TexturingState("aw_or_reverse", () -> {
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
    }, () -> {
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    });
    private static final RenderState.TextureState EMPTY_TEXTURE = new RenderState.TextureState(){

        public void func_228547_a_() {
        }

        public void func_228549_b_() {
        }
    };
    private static final RenderState.TransparencyState DEFAULT_TRANSPARENCY = new RenderState.TransparencyState("aw_defaul_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend());
    private static final Map<SkinVertexFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderTypeImpl._make(it -> {
        it.put(SkinVertexFormat.LINE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181706_f, 1, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.LINE_STRIP, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181706_f, 3, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227852_q_, 7, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.BLIT_MASK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181706_f, 4, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.GUI_IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181707_g, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228724_a_(EMPTY_TEXTURE)));
        it.put(SkinVertexFormat.GUI_COLOR, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181706_f, 7, builder -> builder.func_228726_a_(DEFAULT_TRANSPARENCY)));
        it.put(SkinVertexFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_181705_e, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228725_a_(OR_REVERSE)));
        it.put(SkinVertexFormat.BLOCK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinVertexFormat.BLOCK_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinVertexFormat.ENTITY_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinVertexFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinVertexFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_)));
        it.put(SkinVertexFormat.ENTITY_ALPHA, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET)).emissive());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_).func_228713_a_(field_228517_i_)));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)).emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)).emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 7, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)).emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 4, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 4, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)).emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 4, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_)));
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormats.field_227849_i_, 4, builder -> builder.func_228725_a_(COLORS_OFFSET).func_228713_a_(field_228517_i_)).emissive());
    });

    public AbstractRenderTypeImpl(String name, RenderType delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.func_228663_p_(), delegate.func_228664_q_(), delegate.func_228662_o_(), affectsCrumbling, sortUpload, () -> {
            delegate.func_228547_a_();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.func_228549_b_();
        });
    }

    private static Builder _builder(VertexFormat format, int mode, Function<RenderType.State.Builder, RenderType.State.Builder> config) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder = config.apply(builder.stateBuilder);
        return builder;
    }

    public static IRenderTypeBuilder builder(SkinVertexFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            IRenderTypeBuilder builder = provider.get();
            if (builder instanceof AbstractRenderType.Builder) {
                AbstractRenderType.Builder builder1 = (AbstractRenderType.Builder)builder;
                builder1.format(format);
            }
            return builder;
        }
        throw new RuntimeException("can't supported render format");
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    extends AbstractRenderType.Builder {
        private static final Map<IRenderType.Target, RenderState.TargetState> TABLE_OUTPUT = Builder._make(it -> {
            it.put(IRenderType.Target.TRANSLUCENT, field_239236_S_);
            it.put(IRenderType.Target.MAIN, field_228504_N_);
        });
        private static final Map<IRenderType.Transparency, RenderState.TransparencyState> TABLE_TRANSPARENCY = Builder._make(it -> {
            it.put(IRenderType.Transparency.DEFAULT, DEFAULT_TRANSPARENCY);
            it.put(IRenderType.Transparency.TRANSLUCENT, field_228515_g_);
            it.put(IRenderType.Transparency.NONE, field_228510_b_);
        });
        private static final Map<IRenderType.WriteMask, RenderState.WriteMaskState> TABLE_WRITE_MASK = Builder._make(it -> {
            it.put(IRenderType.WriteMask.COLOR_DEPTH_WRITE, field_228495_E_);
            it.put(IRenderType.WriteMask.COLOR_WRITE, field_228496_F_);
            it.put(IRenderType.WriteMask.DEPTH_WRITE, field_228497_G_);
        });
        private static final Map<IRenderType.DepthTest, RenderState.DepthTestState> TABLE_DEPTH_TEST = Builder._make(it -> {
            it.put(IRenderType.DepthTest.NONE, field_228492_B_);
            it.put(IRenderType.DepthTest.EQUAL, field_228493_C_);
            it.put(IRenderType.DepthTest.LESS_EQUAL, field_228494_D_);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        RenderType renderType;
        RenderType.State.Builder stateBuilder = RenderType.State.func_228694_a_();
        int mode;
        VertexFormat format;

        private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
            HashMap map = new HashMap();
            consumer.accept(map);
            return map;
        }

        private Builder(VertexFormat format, int mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            if (this.renderType != null) {
                this.affectsCrumbling = this.renderType.func_228665_s_();
            }
            this.stateBuilder.func_228714_a_(field_228491_A_);
        }

        @Override
        public IRenderTypeBuilder texture(IResourceLocation texture, boolean blur, boolean mipmap) {
            RenderState.TextureState state = new RenderState.TextureState(texture.toLocation(), blur, mipmap);
            this.stateBuilder = this.stateBuilder.func_228724_a_(state);
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderType.Texturing texturing) {
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderType.Target target) {
            this.stateBuilder = this.stateBuilder.func_228721_a_(TABLE_OUTPUT.getOrDefault((Object)target, field_228504_N_));
            return super.target(target);
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderType.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.func_228726_a_(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, field_228510_b_));
            return super.transparency(transparency);
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderType.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.func_228727_a_(TABLE_WRITE_MASK.getOrDefault((Object)mask, field_228495_E_));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderType.DepthTest test) {
            this.stateBuilder = this.stateBuilder.func_228715_a_(TABLE_DEPTH_TEST.getOrDefault((Object)test, field_228492_B_));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderType.ColorLogic state) {
            RenderType.State.Builder builder;
            switch (state) {
                case OR_REVERSE: {
                    builder = this.stateBuilder.func_228725_a_(OR_REVERSE);
                    break;
                }
                default: {
                    builder = this.stateBuilder.func_228725_a_(field_228524_p_);
                }
            }
            this.stateBuilder = builder;
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.func_228718_a_(new RenderState.LayerState("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.func_228718_a_(new RenderState.LayerState("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.func_228720_a_(new RenderState.LineState(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.func_228714_a_(field_228534_z_);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.func_228719_a_(field_228528_t_);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.func_228722_a_(field_228530_v_);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public IRenderType build(String name) {
            AbstractRenderType renderType = AbstractRenderType.of((RenderType)RenderType.func_228633_a_((String)name, (VertexFormat)this.format, (int)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (RenderType.State)this.stateBuilder.func_228728_a_(this.isOutline)));
            renderType.apply(this.updater);
            return renderType;
        }
    }
}

