/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.armature.IJointFilter;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModelProvider;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;

public class BakedArmatureTransformer {
    public static final BakedArmatureTransformer EMPTY = new BakedArmatureTransformer();
    private final Armature armature;
    private final ArmatureTransformer armatureTransformer;
    private final IJointTransform[] transforms;
    private final ArrayList<ArmaturePlugin> plugins = new ArrayList();
    private IJointFilter filter;

    private BakedArmatureTransformer() {
        this.armature = null;
        this.armatureTransformer = null;
        this.transforms = null;
    }

    public BakedArmatureTransformer(ArmatureTransformer armatureTransformer) {
        this.armature = armatureTransformer.armature();
        this.armatureTransformer = armatureTransformer;
        this.transforms = armatureTransformer.transforms();
    }

    public static BakedArmatureTransformer create(ArmatureTransformer transformer, EntityRenderer<?> entityRenderer) {
        if (transformer == null) {
            return null;
        }
        ArmatureTransformerContext context = transformer.context();
        ArrayList<ArmaturePlugin> plugins = Collections.newList(transformer.plugins());
        context.setEntityRenderer(entityRenderer);
        if (context.entityModel() == null && entityRenderer instanceof IModelProvider) {
            IModelProvider modelProvider = (IModelProvider)entityRenderer;
            context.setEntityModel(modelProvider.getModel(null));
        }
        plugins.removeIf(plugin -> !plugin.freeze());
        BakedArmatureTransformer armatureTransformer1 = new BakedArmatureTransformer(transformer);
        armatureTransformer1.setPlugins(plugins);
        return armatureTransformer1;
    }

    public void prepare(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.prepare(entity, context);
        }
    }

    public void activate(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.activate(entity, context);
        }
    }

    public void deactivate(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.deactivate(entity, context);
        }
    }

    public void applyTo(BakedArmature bakedArmature) {
        if (bakedArmature.armature() == this.armature) {
            bakedArmature.setFilter(this.filter);
            bakedArmature.seTransforms(this.transforms);
        }
    }

    public void setPlugins(Collection<ArmaturePlugin> plugins) {
        this.plugins.clear();
        this.plugins.addAll(plugins);
    }

    public Collection<ArmaturePlugin> plugins() {
        return this.plugins;
    }

    public void setFilter(IJointFilter filter) {
        this.filter = filter;
    }

    public IJointFilter filter() {
        return this.filter;
    }

    public ArmatureTransformer transformer() {
        return this.armatureTransformer;
    }

    public Armature armature() {
        return this.armature;
    }
}

