/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererLayerProvider;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractLivingEntityRenderer;
import moe.plushie.armourers_workshop.core.client.model.MannequinArmorModel;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinEntityRenderer<T extends MannequinEntity>
extends AbstractLivingEntityRenderer<T, MannequinModel<T>> {
    public static boolean enableLimitScale = false;
    public static boolean enableLimitYRot = false;
    private final AbstractEntityRendererProviderImpl.Context context;
    private final MannequinModel<T> normalModel;
    private final MannequinModel<T> slimModel;
    private final LayerRenderer<T, MannequinModel<T>> normalArmorLayer;
    private final LayerRenderer<T, MannequinModel<T>> slimArmorLayer;
    private MannequinEntityRenderer<T> mannequinRenderer;
    private OpenResourceLocation texture;
    private BakedEntityTexture bakedTexture;
    private EntityTextureDescriptor.Model textureModel = EntityTextureDescriptor.Model.STEVE;
    private boolean enableChildRenderer = false;

    public MannequinEntityRenderer(AbstractEntityRendererProviderImpl.Context context) {
        super(context, MannequinModel.normal(context), 0.0f);
        AbstractEntityRendererLayerProvider provider = this.getLayerProvider();
        this.context = context;
        this.normalModel = (MannequinModel)super.func_217764_d();
        this.slimModel = MannequinModel.slim(context);
        this.normalArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.normalInner(context), MannequinArmorModel.normalOuter(context));
        this.slimArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.slimInner(context), MannequinArmorModel.slimOuter(context));
        this.func_177094_a(this.normalArmorLayer);
        this.func_177094_a(provider.createItemInHandLayer(context));
        this.func_177094_a(provider.createElytraLayer(context));
        this.func_177094_a(provider.createCustomHeadLayer(context));
    }

    public boolean shouldShowName(T entity) {
        return entity.func_145818_k_();
    }

    @Override
    public void render(T entity, float f, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int packedLightIn) {
        if (this.enableChildRenderer) {
            this.getChildRenderer().render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
            return;
        }
        EntityTextureLoader textureLoader = EntityTextureLoader.getInstance();
        this.texture = textureLoader.getTextureLocation((Entity)entity);
        this.bakedTexture = textureLoader.getTextureModel(this.texture);
        this.applyTextureModel(((MannequinEntity)entity).getTextureModel());
        ((MannequinModel)super.func_217764_d()).func_178719_a(((MannequinEntity)entity).isModelVisible());
        this.enableChildRenderer = true;
        super.render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
        this.enableChildRenderer = false;
        if (ModDebugger.mannequinCulling) {
            poseStack.pushPose();
            AxisAlignedBB box = ((MannequinEntity)entity).func_184177_bl();
            double tx = -box.field_72340_a - (box.field_72336_d - box.field_72340_a) / 2.0;
            double ty = -box.field_72338_b;
            double tz = -box.field_72339_c - (box.field_72334_f - box.field_72339_c) / 2.0;
            poseStack.translate((float)tx, (float)ty, (float)tz);
            ShapeTesselator.stroke(box, UIColor.YELLOW, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    @Override
    public float getEntityScale(T entity) {
        float f = 0.9375f;
        if (!enableLimitScale) {
            f *= ((MannequinEntity)entity).func_213355_cm();
        }
        return f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (this.texture != null) {
            return this.texture.toLocation();
        }
        return ModTextures.MANNEQUIN_DEFAULT.toLocation();
    }

    public MannequinEntityRenderer<T> getChildRenderer() {
        if (this.mannequinRenderer == null) {
            this.mannequinRenderer = new MannequinEntityRenderer<T>(this.context);
        }
        return this.mannequinRenderer;
    }

    private void applyTextureModel(EntityTextureDescriptor.Model newValue) {
        if (this.textureModel == newValue) {
            return;
        }
        this.textureModel = newValue;
        if (newValue == EntityTextureDescriptor.Model.STEVE) {
            this.setModel(this.normalModel);
            this.replaceTo(this.slimArmorLayer, this.normalArmorLayer);
        } else {
            this.setModel(this.slimModel);
            this.replaceTo(this.normalArmorLayer, this.slimArmorLayer);
        }
    }

    private void replaceTo(LayerRenderer<T, MannequinModel<T>> fromLayer, LayerRenderer<T, MannequinModel<T>> toLayer) {
        int index = this.field_177097_h.indexOf(fromLayer);
        if (index >= 0) {
            LayerRenderer<T, MannequinModel<T>> layerRenderer = this.field_177097_h.set(index, toLayer);
        }
    }
}

