/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.client.shader.ShaderContext;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniform;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class ShaderUniforms {
    private static ShaderUniforms INSTANCE = new ShaderUniforms();
    private final Int2ObjectMap<State> states = new Int2ObjectOpenHashMap();

    public static ShaderUniforms getInstance() {
        return INSTANCE;
    }

    public static void begin() {
    }

    public static void end() {
        ShaderUniforms instance = ShaderUniforms.getInstance();
        int currentProgram = GL20.glGetInteger((int)35725);
        instance.states.forEach((programId, state) -> {
            if (!state.isChanged()) {
                return;
            }
            if (currentProgram != programId) {
                GL20.glUseProgram((int)programId);
            }
            state.reset();
            if (currentProgram != programId) {
                GL20.glUseProgram((int)currentProgram);
            }
        });
    }

    public static void clear() {
        if (ShaderUniforms.getInstance().states.isEmpty()) {
            return;
        }
        INSTANCE = new ShaderUniforms();
        ModLog.debug("reset all uniforms from shader changes", new Object[0]);
    }

    public void apply(int programId) {
        if (programId == 0) {
            return;
        }
        State state = (State)this.states.computeIfAbsent(programId, State::new);
        if (!state.isEmpty()) {
            state.apply();
        }
    }

    private static class State {
        private final List<ShaderUniform> uniforms;
        private List<ShaderUniform> changes;

        public State(int program) {
            this.uniforms = Builder.of(program).built(ShaderContext.getInstance()).build();
        }

        public void apply() {
            if (this.changes == null) {
                this.uniforms.forEach(ShaderUniform::push);
                this.changes = this.uniforms;
            }
            this.uniforms.forEach(ShaderUniform::apply);
        }

        public void reset() {
            if (this.changes != null) {
                this.uniforms.forEach(ShaderUniform::pop);
                this.changes = null;
            }
        }

        public boolean isEmpty() {
            return this.uniforms.isEmpty();
        }

        public boolean isChanged() {
            return this.changes != null;
        }
    }

    private static interface Factory<T> {
        public ShaderUniform create(String var1, int var2, int var3, Supplier<T> var4);
    }

    private static class Builder {
        final int programId;
        final ArrayList<ShaderUniform> uniforms = new ArrayList();

        private Builder(int programId) {
            this.programId = programId;
        }

        public static Builder of(int programId) {
            return new Builder(programId);
        }

        public Builder built(ShaderContext context) {
            this.add("aw_MatrixFlags", context::matrixFlags, ShaderUniform.Int::new);
            this.add("aw_NormalMatrix", context::objectNormalMatrix, ShaderUniform.Matrix3f::new);
            this.add("aw_ModelViewMatrix", context::objectViewMatrix, ShaderUniform.Matrix4f::new);
            this.add("aw_OverlayTextureMatrix", context::overlayTextureMatrix, ShaderUniform.Matrix4f::new);
            this.add("aw_LightmapTextureMatrix", context::lightmapTextureMatrix, ShaderUniform.Matrix4f::new);
            this.add("aw_TextureMatrix", context::textureMatrix, ShaderUniform.Matrix4f::new);
            this.add("aw_ColorModulator", context::colorModulator, ShaderUniform.Vec4f::new);
            return this;
        }

        public <T> Builder add(String name, Supplier<T> supplier, Factory<T> factory) {
            int location = GL20.glGetUniformLocation((int)this.programId, (CharSequence)name);
            if (location != -1) {
                this.uniforms.add(factory.create(name, this.programId, location, supplier));
            }
            return this;
        }

        public ArrayList<ShaderUniform> build() {
            return this.uniforms;
        }
    }
}

