/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.ArrayAccess;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Binary;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Call;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Literal;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Return;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Statement;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.StructAccess;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Unary;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Lexer;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Optimizer;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.SyntaxException;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.ObjectBinding;

public class Compiler {
    protected final ObjectBinding bindings;
    protected final Optimizer optimizer;

    public Compiler(ObjectBinding bindings) {
        this.bindings = bindings;
        this.optimizer = new Optimizer();
    }

    public Expression compile(String source) throws SyntaxException {
        Expression expression = this.parseAll(source);
        expression = this.optimizer.transform(expression);
        return expression;
    }

    private Expression parseAll(String source) throws SyntaxException {
        Lexer.Token token;
        Lexer lexer = new Lexer(source);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        while ((token = lexer.next()).kind() != Lexer.Kind.EOF) {
            if (token.kind() == Lexer.Kind.ERROR) {
                throw new SyntaxException("Found an invalid token (error): " + token.value(), lexer.cursor());
            }
            Expression expr = this.parseCompoundExpression(lexer, 0);
            token = lexer.current();
            if (token.kind() != Lexer.Kind.EOF && token.kind() != Lexer.Kind.SEMICOLON) {
                throw new SyntaxException("Expected a semicolon, but was " + token, lexer.cursor());
            }
            expressions.add(expr);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return new Compound(expressions);
    }

    private Expression parseSingle(Lexer lexer) throws SyntaxException {
        Expression expression;
        Lexer.Token token = lexer.current();
        switch (token.kind()) {
            case NUMBER: {
                lexer.next();
                expression = new Constant(Double.parseDouble(token.value()));
                break;
            }
            case STRING: {
                lexer.next();
                expression = new Literal(token.value());
                break;
            }
            case TRUE: {
                lexer.next();
                expression = Constant.ONE;
                break;
            }
            case FALSE: {
                lexer.next();
                expression = Constant.ZERO;
                break;
            }
            case LPAREN: {
                lexer.next();
                Expression expression2 = this.parseCompoundExpression(lexer, 0);
                token = lexer.current();
                if (token.kind() != Lexer.Kind.RPAREN) {
                    throw new SyntaxException("Non closed expression", lexer.cursor());
                }
                lexer.next();
                expression = expression2;
                break;
            }
            case LBRACE: {
                token = lexer.next();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                while (token.kind() != Lexer.Kind.RBRACE) {
                    expressions.add(this.parseCompoundExpression(lexer, 0));
                    token = lexer.current();
                    if (token.kind() == Lexer.Kind.RBRACE) break;
                    if (token.kind() == Lexer.Kind.EOF) {
                        throw new SyntaxException("Found the end before the execution scope closing token", lexer.cursor());
                    }
                    if (token.kind() == Lexer.Kind.ERROR) {
                        throw new SyntaxException("Found an invalid token (error): " + token.value(), lexer.cursor());
                    }
                    if (token.kind() != Lexer.Kind.SEMICOLON) {
                        throw new SyntaxException("Missing semicolon", lexer.cursor());
                    }
                    token = lexer.next();
                }
                lexer.next();
                expression = new Compound(expressions);
                break;
            }
            case BREAK: {
                lexer.next();
                expression = new Statement(Statement.Operator.BREAK);
                break;
            }
            case CONTINUE: {
                lexer.next();
                expression = new Statement(Statement.Operator.CONTINUE);
                break;
            }
            case IDENTIFIER: {
                Expression expr = this.bindings.propertyByName(token.value());
                if (expr == null) {
                    throw new SyntaxException("Failed to get property: " + token.value(), lexer.cursor());
                }
                token = lexer.next();
                if (token.kind() == Lexer.Kind.DOT) {
                    token = lexer.next();
                    if (token.kind() != Lexer.Kind.IDENTIFIER) {
                        throw new SyntaxException("Unexpected token, expected a valid field token", lexer.cursor());
                    }
                    if (!(expr instanceof ObjectBinding)) {
                        throw new SyntaxException("Illegal access to: " + expr + "." + token.value(), lexer.cursor());
                    }
                    ObjectBinding parent = (ObjectBinding)expr;
                    expr = parent.propertyByName(token.value());
                    if (expr == null) {
                        throw new SyntaxException("Failed to get property: " + parent + "." + token.value(), lexer.cursor());
                    }
                    lexer.next();
                }
                expression = expr;
                break;
            }
            case SUB: {
                lexer.next();
                Expression expr = this.parseCompoundExpression(lexer, Unary.Operator.ARITHMETICAL_NEGATION.precedence());
                if (expr instanceof Constant) {
                    Constant constant = (Constant)expr;
                    expression = new Constant(-constant.value().getAsDouble());
                    break;
                }
                expression = new Unary(Unary.Operator.ARITHMETICAL_NEGATION, expr);
                break;
            }
            case PLUS: {
                lexer.next();
                expression = this.parseCompoundExpression(lexer, Unary.Operator.ARITHMETICAL_PLUS.precedence());
                break;
            }
            case BANG: {
                lexer.next();
                Expression expr = this.parseCompoundExpression(lexer, Unary.Operator.LOGICAL_NEGATION.precedence());
                expression = new Unary(Unary.Operator.LOGICAL_NEGATION, expr);
                break;
            }
            case RETURN: {
                lexer.next();
                Expression expr = this.parseCompoundExpression(lexer, 0);
                expression = new Return(expr);
                break;
            }
            default: {
                expression = Constant.ZERO;
            }
        }
        return expression;
    }

    private Expression parseCompoundExpression(Lexer lexer, int lastPrecedence) throws SyntaxException {
        Expression expr = this.parseSingle(lexer);
        while (true) {
            Expression compoundExpr = this.parseCompound(lexer, expr, lastPrecedence);
            Lexer.Token current = lexer.current();
            if (current.kind() == Lexer.Kind.EOF || current.kind() == Lexer.Kind.SEMICOLON) {
                return compoundExpr;
            }
            if (compoundExpr == expr) {
                return expr;
            }
            expr = compoundExpr;
        }
    }

    private Expression parseCompound(Lexer lexer, Expression left, int lastPrecedence) throws SyntaxException {
        Binary.Operator op;
        Lexer.Token token = lexer.current();
        switch (token.kind()) {
            case RPAREN: 
            case EOF: {
                return left;
            }
            case DOT: {
                Expression expr = left;
                while (token.kind() == Lexer.Kind.DOT) {
                    token = lexer.next();
                    if (token.kind() != Lexer.Kind.IDENTIFIER) {
                        throw new SyntaxException("Unexpected token, expected a valid field token", lexer.cursor());
                    }
                    expr = new StructAccess(expr, token.value());
                    token = lexer.next();
                }
                if (expr == left) {
                    throw new SyntaxException("Unexpected token, expected a valid field token", lexer.cursor());
                }
                return expr;
            }
            case LBRACKET: {
                token = lexer.next();
                if (token.kind() == Lexer.Kind.RBRACKET) {
                    throw new SyntaxException("Expected a expression, got RBRACKET", lexer.cursor());
                }
                if (token.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                Expression index = this.parseCompoundExpression(lexer, 0);
                token = lexer.current();
                if (token.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                if (token.kind() != Lexer.Kind.RBRACKET) {
                    throw new SyntaxException("Expected a closing RBRACKET, found " + token, lexer.cursor());
                }
                lexer.next();
                return new ArrayAccess(left, index);
            }
            case LPAREN: {
                token = lexer.next();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                if (token.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RPAREN", lexer.cursor());
                }
                while (token.kind() != Lexer.Kind.RPAREN) {
                    arguments.add(this.parseCompoundExpression(lexer, 0));
                    token = lexer.current();
                    if (token.kind() == Lexer.Kind.EOF) {
                        throw new SyntaxException("Found EOF before closing RPAREN", lexer.cursor());
                    }
                    if (token.kind() == Lexer.Kind.ERROR) {
                        throw new SyntaxException("Found error token: " + token.value(), lexer.cursor());
                    }
                    if (token.kind() == Lexer.Kind.RPAREN) break;
                    if (token.kind() != Lexer.Kind.COMMA) {
                        throw new SyntaxException("Expected a comma, got " + (Object)((Object)token.kind()), lexer.cursor());
                    }
                    lexer.next();
                }
                lexer.next();
                return new Call(left, arguments);
            }
            case QUES: {
                int conditionalPrecedence = Binary.Operator.CONDITIONAL.precedence();
                if (lastPrecedence > conditionalPrecedence) {
                    return left;
                }
                lexer.next();
                Expression trueValue = this.parseCompoundExpression(lexer, conditionalPrecedence);
                if (lexer.current().kind() == Lexer.Kind.COLON) {
                    lexer.next();
                    Expression falseValue = this.parseCompoundExpression(lexer, conditionalPrecedence);
                    return new Ternary(left, trueValue, falseValue);
                }
                return new Binary(Binary.Operator.CONDITIONAL, left, trueValue);
            }
            case ARROW: {
                lexer.next();
                Expression right = this.parseCompoundExpression(lexer, 0);
                return new Binary(Binary.Operator.ARROW, left, right);
            }
        }
        switch (token.kind()) {
            case AMPAMP: {
                Binary.Operator operator = Binary.Operator.AND;
                break;
            }
            case BARBAR: {
                Binary.Operator operator = Binary.Operator.OR;
                break;
            }
            case LT: {
                Binary.Operator operator = Binary.Operator.LT;
                break;
            }
            case LTE: {
                Binary.Operator operator = Binary.Operator.LTE;
                break;
            }
            case GT: {
                Binary.Operator operator = Binary.Operator.GT;
                break;
            }
            case GTE: {
                Binary.Operator operator = Binary.Operator.GTE;
                break;
            }
            case PLUS: {
                Binary.Operator operator = Binary.Operator.ADD;
                break;
            }
            case SUB: {
                Binary.Operator operator = Binary.Operator.SUB;
                break;
            }
            case STAR: {
                Binary.Operator operator = Binary.Operator.MUL;
                break;
            }
            case SLASH: {
                Binary.Operator operator = Binary.Operator.DIV;
                break;
            }
            case MOD: {
                Binary.Operator operator = Binary.Operator.MOD;
                break;
            }
            case POW: {
                Binary.Operator operator = Binary.Operator.POW;
                break;
            }
            case QUESQUES: {
                Binary.Operator operator = Binary.Operator.NULL_COALESCE;
                break;
            }
            case EQ: {
                Binary.Operator operator = Binary.Operator.ASSIGN;
                break;
            }
            case EQEQ: {
                Binary.Operator operator = Binary.Operator.EQ;
                break;
            }
            case BANGEQ: {
                Binary.Operator operator = Binary.Operator.NEQ;
                break;
            }
            case PLUSEQ: {
                Binary.Operator operator = Binary.Operator.ADD_ASSIGN;
                break;
            }
            case SUBEQ: {
                Binary.Operator operator = Binary.Operator.SUB_ASSIGN;
                break;
            }
            case STAREQ: {
                Binary.Operator operator = Binary.Operator.MUL_ASSIGN;
                break;
            }
            case SLASHEQ: {
                Binary.Operator operator = Binary.Operator.DIV_ASSIGN;
                break;
            }
            case MODEQ: {
                Binary.Operator operator = Binary.Operator.MOD_ASSIGN;
                break;
            }
            case POWEQ: {
                Binary.Operator operator = Binary.Operator.POW_ASSIGN;
                break;
            }
            case QUESQUESEQ: {
                Binary.Operator operator = Binary.Operator.NULL_COALESCE_ASSIGN;
                break;
            }
            default: {
                Binary.Operator operator = op = null;
            }
        }
        if (op == null || lastPrecedence >= op.precedence()) {
            return left;
        }
        lexer.next();
        Expression right = this.parseCompoundExpression(lexer, op.precedence());
        return new Binary(op, left, right);
    }
}

