/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.LinkedList;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.registry.IBlockEntityTypeBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryBinder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProvider;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeBlockEntity;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.client.renderer.GameRenderer.ForgeRegistry;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BlockEntityTypeBuilderImpl<T extends TileEntity>
implements IBlockEntityTypeBuilder<T> {
    private IRegistryBinder<TileEntityType<T>> binder;
    private final LinkedList<Supplier<Block>> blocks = new LinkedList();
    private final IBlockEntityType.Serializer<T> supplier;

    public BlockEntityTypeBuilderImpl(IBlockEntityType.Serializer<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public IBlockEntityTypeBuilder<T> of(Supplier<Block> block) {
        this.blocks.add(block);
        return this;
    }

    @Override
    public IBlockEntityTypeBuilder<T> bind(Supplier<AbstractBlockEntityRendererProvider<T>> provider) {
        this.binder = () -> arg_0 -> BlockEntityTypeBuilderImpl.lambda$bind$0((Supplier)provider, arg_0);
        return this;
    }

    @Override
    public IRegistryHolder<IBlockEntityType<T>> build(String name) {
        IRegistryHolder object = AbstractForgeRegistries.BLOCK_ENTITY_TYPES.register(name, () -> {
            Block[] blocks1 = (Block[])this.blocks.stream().map(Supplier::get).toArray(Block[]::new);
            return AbstractForgeBlockEntity.createType(this.supplier, blocks1);
        });
        Proxy proxy = new Proxy(object);
        EnvironmentExecutor.willInit(EnvironmentType.CLIENT, IRegistryBinder.perform(this.binder, object));
        return TypedRegistry.Entry.of(object.registryName(), () -> proxy);
    }

    private static /* synthetic */ void lambda$bind$0(Supplier provider, IRegistryHolder blockEntityType) {
        ForgeRegistry.registerBlockEntityRendererFO(GameRenderer.class, blockEntityType, (AbstractBlockEntityRendererProvider)provider.get());
    }

    public static class Proxy<T extends TileEntity>
    implements IBlockEntityType<T> {
        private final IRegistryHolder<TileEntityType<T>> object;

        public Proxy(IRegistryHolder<TileEntityType<T>> object) {
            this.object = object;
        }

        @Override
        public T create(IBlockReader level, BlockPos blockPos, BlockState blockState) {
            return AbstractForgeBlockEntity.create((TileEntityType)this.object.get(), level, blockPos, blockState);
        }

        @Override
        public TileEntityType<T> get() {
            return (TileEntityType)this.object.get();
        }
    }
}

