/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.vector.Vector3f;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AimAnimation
extends StaticAnimation {
    public StaticAnimation lookUp;
    public StaticAnimation lookDown;
    public StaticAnimation lying;

    public AimAnimation(float convertTime, boolean repeatPlay, String path1, String path2, String path3, String path4, Model model) {
        super(convertTime, repeatPlay, path1, model);
        this.lookUp = new StaticAnimation(convertTime, repeatPlay, path2, model, true);
        this.lookDown = new StaticAnimation(convertTime, repeatPlay, path3, model, true);
        this.lying = new StaticAnimation(convertTime, repeatPlay, path4, model, true);
    }

    public AimAnimation(boolean repeatPlay, String path1, String path2, String path3, String path4, Model model) {
        this(0.15f, repeatPlay, path1, path2, path3, path4, model);
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ClientAnimator animator = entitypatch.getClientAnimator();
        Layer layer = animator.getCompositeLayer(this.getPriority());
        AnimationPlayer player = layer.animationPlayer;
        if (player.getElapsedTime() >= this.totalTime - 0.06f) {
            layer.pause();
        }
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (!entitypatch.isFirstPerson()) {
            if (((LivingEntity)entitypatch.getOriginal()).func_213314_bj() || ((LivingEntity)entitypatch.getOriginal()).func_184613_cA() || ((LivingEntity)entitypatch.getOriginal()).func_204805_cN()) {
                Pose pose = this.lying.getPoseByTime(entitypatch, time, partialTicks);
                this.modifyPose(pose, entitypatch, time);
                return pose;
            }
            float pitch = ((LivingEntity)entitypatch.getOriginal()).func_195050_f(Minecraft.func_71410_x().func_184121_ak());
            StaticAnimation interpolateAnimation = pitch > 0.0f ? this.lookDown : this.lookUp;
            Pose pose1 = super.getPoseByTime(entitypatch, time, partialTicks);
            Pose pose2 = interpolateAnimation.getPoseByTime(entitypatch, time, partialTicks);
            this.modifyPose(pose2, entitypatch, time);
            Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, Math.abs(pitch) / 90.0f);
            return interpolatedPose;
        }
        return super.getPoseByTime(entitypatch, time, partialTicks);
    }

    @Override
    protected void modifyPose(Pose pose, LivingEntityPatch<?> entitypatch, float time) {
        if (!entitypatch.isFirstPerson()) {
            JointTransform chest = pose.getOrDefaultTransform("Chest");
            JointTransform head = pose.getOrDefaultTransform("Head");
            float f = 90.0f;
            float ratio = (f - Math.abs(((LivingEntity)entitypatch.getOriginal()).field_70125_A)) / f;
            float yawOffset = ((LivingEntity)entitypatch.getOriginal()).func_184187_bx() != null ? ((LivingEntity)entitypatch.getOriginal()).field_70177_z : ((LivingEntity)entitypatch.getOriginal()).field_70761_aq;
            MathUtils.mulQuaternion(Vector3f.field_229181_d_.func_229187_a_((yawOffset - ((LivingEntity)entitypatch.getOriginal()).field_70177_z) * ratio), head.rotation(), head.rotation());
            chest.frontResult(JointTransform.getRotation(Vector3f.field_229181_d_.func_229187_a_((((LivingEntity)entitypatch.getOriginal()).field_70177_z - yawOffset) * ratio)), OpenMatrix4f::mulAsOriginFront);
        }
    }

    @Override
    public <V> StaticAnimation addProperty(AnimationProperty.StaticAnimationProperty<V> propertyType, V value) {
        super.addProperty(propertyType, value);
        this.lookDown.addProperty(propertyType, value);
        this.lookUp.addProperty(propertyType, value);
        this.lying.addProperty(propertyType, value);
        return this;
    }

    @Override
    public void loadAnimation(IResourceManager resourceManager) {
        AimAnimation.load(resourceManager, this);
        AimAnimation.load(resourceManager, this.lookUp);
        AimAnimation.load(resourceManager, this.lookDown);
        AimAnimation.load(resourceManager, this.lying);
    }
}

