/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.client.animation.JointMask;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class DynamicAnimation {
    protected Map<String, TransformSheet> jointTransforms = new HashMap<String, TransformSheet>();
    protected final boolean isRepeat;
    protected final float convertTime;
    protected float totalTime = 0.0f;

    public DynamicAnimation() {
        this(0.15f, false);
    }

    public DynamicAnimation(float convertTime, boolean isRepeat) {
        this.isRepeat = isRepeat;
        this.convertTime = convertTime;
    }

    public void addSheet(String jointName, TransformSheet sheet) {
        this.jointTransforms.put(jointName, sheet);
    }

    public final Pose getPoseByTimeRaw(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            if (entitypatch.isLogicalClient() && !this.isJointEnabled(entitypatch, jointName)) continue;
            pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(time));
        }
        return pose;
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            if (entitypatch.isLogicalClient() && !this.isJointEnabled(entitypatch, jointName)) continue;
            pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(time));
        }
        this.modifyPose(pose, entitypatch, time);
        return pose;
    }

    protected void modifyPose(Pose pose, LivingEntityPatch<?> entitypatch, float time) {
    }

    public void setLinkAnimation(Pose pose1, float convertTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        float nextStart;
        if (!entitypatch.isLogicalClient()) {
            pose1 = Animations.DUMMY_ANIMATION.getPoseByTime(entitypatch, 0.0f, 1.0f);
        }
        float totalTime = convertTimeModifier >= 0.0f ? convertTimeModifier + this.convertTime : this.convertTime;
        boolean isNeg = convertTimeModifier < 0.0f;
        float f = nextStart = isNeg ? -convertTimeModifier : 0.0f;
        if (isNeg) {
            dest.startsAt = nextStart;
        }
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setNextAnimation(this);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Map<String, JointTransform> data2 = this.getPoseByTime(entitypatch, nextStart, 1.0f).getJointTransformData();
        for (String jointName : data1.keySet()) {
            if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
            Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName)), new Keyframe(totalTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }

    public void putOnPlayer(AnimationPlayer player) {
        player.setPlayAnimation(this);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
    }

    public void end(LivingEntityPatch<?> entitypatch, boolean isEnd) {
    }

    public void linkTick(LivingEntityPatch<?> entitypatch, LinkAnimation linkAnimation) {
    }

    public boolean isJointEnabled(LivingEntityPatch<?> entitypatch, String joint) {
        return this.jointTransforms.containsKey(joint);
    }

    public JointMask.BindModifier getBindModifier(LivingEntityPatch<?> entitypatch, String joint) {
        return null;
    }

    public EntityState getState(float time) {
        return EntityState.DEFAULT;
    }

    public Map<String, TransformSheet> getTransfroms() {
        return this.jointTransforms;
    }

    public float getPlaySpeed(LivingEntityPatch<?> entitypatch) {
        return 1.0f;
    }

    public DynamicAnimation getRealAnimation() {
        return this;
    }

    public void setTotalTime(float totalTime) {
        this.totalTime = totalTime;
    }

    public float getTotalTime() {
        return this.totalTime - 0.001f;
    }

    public float getConvertTime() {
        return this.convertTime;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public boolean canBePlayedReverse() {
        return false;
    }

    public int getNamespaceId() {
        return -1;
    }

    public int getId() {
        return -1;
    }

    public <V> Optional<V> getProperty(AnimationProperty<V> propertyType) {
        return Optional.empty();
    }

    public boolean isMainFrameAnimation() {
        return false;
    }

    public boolean isReboundAnimation() {
        return false;
    }

    public boolean isMetaAnimation() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(MatrixStack poseStack, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
    }
}

