/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MainFrameAnimation
extends StaticAnimation {
    public MainFrameAnimation(float convertTime, String path, Model model) {
        super(convertTime, false, path, model);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.updateEntityState();
        if (entitypatch.isLogicalClient()) {
            entitypatch.getClientAnimator().resetMotion();
            entitypatch.getClientAnimator().resetCompositeMotion();
            entitypatch.getClientAnimator().getPlayerFor(this).setReversed(false);
        }
        if (entitypatch.getOriginal() instanceof PlayerEntity) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            if (playerpatch.isLogicalClient()) {
                if (((PlayerEntity)playerpatch.getOriginal()).func_175144_cb()) {
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, new ActionEvent(playerpatch, this));
                }
            } else {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_SERVER, new ActionEvent(playerpatch, this));
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ((LivingEntity)entitypatch.getOriginal()).field_70721_aZ = 0.0f;
    }

    @Override
    public boolean isMainFrameAnimation() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.HIGHEST);
    }
}

