/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import com.google.common.collect.Lists;
import java.util.Map;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.FABRIK;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public interface ProceduralAnimation {
    default public void setIKInfo(IKInfo[] ikInfos, Map<String, TransformSheet> src, Map<String, TransformSheet> dest, Armature armature, boolean correctY, boolean correctZ) {
        for (IKInfo ikInfo : ikInfos) {
            ikInfo.pathToEndJoint = Lists.newArrayList();
            Joint start = armature.searchJointByName(ikInfo.startJoint);
            ikInfo.pathToEndJoint.add(start.getName());
            for (int pathToEnd = Integer.parseInt(start.searchPath(new String(""), ikInfo.endJoint)); pathToEnd > 0; pathToEnd /= 10) {
                start = start.getSubJoints().get(pathToEnd % 10 - 1);
                ikInfo.pathToEndJoint.add(start.getName());
            }
            Keyframe[] keyframes = src.get(ikInfo.endJoint).getKeyframes();
            Keyframe[] bindedposKeyframes = new Keyframe[keyframes.length];
            int keyframeLength = src.get(ikInfo.endJoint).getKeyframes().length;
            for (int i = 0; i < keyframeLength; ++i) {
                Keyframe kf = keyframes[i];
                Pose pose = new Pose();
                for (String jointName : src.keySet()) {
                    pose.putJointData(jointName, src.get(jointName).getInterpolatedTransform(kf.time()));
                }
                OpenMatrix4f bindedTransform = Animator.getBindedJointTransformByName(pose, armature, ikInfo.endJoint);
                JointTransform bindedJointTransform = JointTransform.fromMatrixNoScale(bindedTransform);
                bindedposKeyframes[i] = new Keyframe(kf);
                JointTransform tipTransform = bindedposKeyframes[i].transform();
                tipTransform.copyFrom(bindedJointTransform);
                if (!correctY && !correctZ) continue;
                JointTransform rootTransform = src.get("Root").getInterpolatedTransform(kf.time());
                Vec3f rootPos = rootTransform.translation();
                float yCorrection = correctY ? -rootPos.z : 0.0f;
                float zCorrection = correctZ ? rootPos.y : 0.0f;
                tipTransform.translation().add(0.0f, yCorrection, zCorrection);
            }
            TransformSheet tipAnimation = new TransformSheet(bindedposKeyframes);
            dest.put(ikInfo.endJoint, tipAnimation);
            if (ikInfo.clipAnimation) {
                TransformSheet part = tipAnimation.copy(ikInfo.startFrame, ikInfo.endFrame);
                Keyframe[] partKeyframes = part.getKeyframes();
                ikInfo.startpos = partKeyframes[0].transform().translation();
                ikInfo.endpos = partKeyframes[partKeyframes.length - 1].transform().translation();
            } else {
                ikInfo.endpos = ikInfo.startpos = tipAnimation.getKeyframes()[0].transform().translation();
            }
            ikInfo.startToEnd = Vec3f.sub(ikInfo.endpos, ikInfo.startpos, null).multiply(-1.0f, 1.0f, -1.0f);
        }
    }

    default public TransformSheet getFirstPart(TransformSheet transformSheet) {
        TransformSheet part = transformSheet.copy(0, 2);
        Keyframe[] keyframes = part.getKeyframes();
        keyframes[1].transform().copyFrom(keyframes[0].transform());
        return part;
    }

    default public TransformSheet clipAnimation(TransformSheet transformSheet, IKInfo ikInfo) {
        if (ikInfo.clipAnimation) {
            return transformSheet.copy(ikInfo.startFrame, ikInfo.endFrame);
        }
        return this.getFirstPart(transformSheet);
    }

    default public Vec3f getRayCastedTipPosition(Vec3f clipStart, OpenMatrix4f toWorldCoord, EnderDragonPatch enderdragonpatch, float maxYDown, float leastHeight) {
        Vec3f clipStartWorld = OpenMatrix4f.transform3v(toWorldCoord, clipStart, null);
        BlockRayTraceResult clipResult = ((EnderDragonEntity)enderdragonpatch.getOriginal()).field_70170_p.func_217299_a(new RayTraceContext(new Vector3d((double)clipStartWorld.x, (double)clipStartWorld.y, (double)clipStartWorld.z), new Vector3d((double)clipStartWorld.x, (double)(clipStartWorld.y - maxYDown), (double)clipStartWorld.z), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, enderdragonpatch.getOriginal()));
        float dy = clipResult.func_216346_c() != RayTraceResult.Type.MISS ? clipStartWorld.y - (float)clipResult.func_216350_a().func_177956_o() - 1.0f : maxYDown;
        return new Vec3f(clipStartWorld.x, clipStartWorld.y - dy + leastHeight, clipStartWorld.z);
    }

    default public void correctRootRotation(JointTransform rootTransform, EnderDragonPatch enderdragonpatch, float partialTicks) {
        float xRoot = enderdragonpatch.xRootO + (enderdragonpatch.xRoot - enderdragonpatch.xRootO) * partialTicks;
        float zRoot = enderdragonpatch.zRootO + (enderdragonpatch.zRoot - enderdragonpatch.zRootO) * partialTicks;
        Quaternion quat = MathUtils.quaternionFromDegree(Vector3f.field_229183_f_, zRoot);
        quat.func_195890_a(MathUtils.quaternionFromDegree(Vector3f.field_229179_b_, -xRoot));
        rootTransform.frontResult(JointTransform.getRotation(quat), OpenMatrix4f::mulAsOriginFront);
    }

    default public void applyFabrikToJoint(Vec3f recalculatedPosition, Pose pose, Armature armature, String startJoint, String endJoint, Quaternion tipRotation) {
        FABRIK fabrik = new FABRIK(pose, armature, startJoint, endJoint);
        fabrik.run(recalculatedPosition, 10);
        OpenMatrix4f tipRotationMatrix = OpenMatrix4f.fromQuaternion(tipRotation);
        OpenMatrix4f animRotation = Animator.getBindedJointTransformByName(pose, armature, endJoint).removeTranslation();
        OpenMatrix4f animToTipRotation = OpenMatrix4f.mul(OpenMatrix4f.invert(animRotation, null), tipRotationMatrix, null);
        pose.getOrDefaultTransform(endJoint).overwriteRotation(JointTransform.fromMatrixNoScale(animToTipRotation));
    }

    default public void startPartAnimation(IKInfo ikInfo, TipPointAnimation tipAnim, TransformSheet partAnimation, Vec3f targetpos) {
        Vec3f footpos = tipAnim.getTipPosition(1.0f);
        Vec3f worldStartToEnd = targetpos.copy().sub(footpos);
        partAnimation.correctAnimationByNewPosition(ikInfo.startpos, ikInfo.startToEnd, footpos, worldStartToEnd);
        tipAnim.start(targetpos, partAnimation, 1.0f);
    }

    default public void startSimple(IKInfo ikInfo, TipPointAnimation tipAnim) {
        tipAnim.start(new Vec3f(0.0f, 0.0f, 0.0f), tipAnim.getAnimation(), 1.0f);
    }
}

