/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.resources.IResource;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.JointMask;
import yesman.epicfight.api.client.animation.JointMaskEntry;
import yesman.epicfight.api.client.animation.Layer;

@OnlyIn(value=Dist.CLIENT)
public class AnimationDataReader {
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(AnimationDataReader.class, (Object)new Deserializer()).create();
    static final TypeToken<AnimationDataReader> TYPE = new TypeToken<AnimationDataReader>(){};
    private JointMaskEntry jointMaskEntry;
    private Layer.LayerType layerType;
    private Layer.Priority priority;

    public static void readAndApply(StaticAnimation animation, IResource iresource) {
        InputStream inputstream = iresource.func_199027_b();
        InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
        AnimationDataReader propertySetter = (AnimationDataReader)JSONUtils.func_233010_a_((Gson)GSON, (Reader)reader, TYPE);
        if (propertySetter.jointMaskEntry.isValid()) {
            animation.addProperty(ClientAnimationProperties.JOINT_MASK, propertySetter.jointMaskEntry);
        }
        animation.addProperty(ClientAnimationProperties.PRIORITY, propertySetter.priority);
        animation.addProperty(ClientAnimationProperties.LAYER_TYPE, propertySetter.layerType);
    }

    private AnimationDataReader(JointMaskEntry jointMaskEntry, Layer.Priority priority, Layer.LayerType layerType) {
        this.jointMaskEntry = jointMaskEntry;
        this.priority = priority;
        this.layerType = layerType;
    }

    private static List<JointMask> getJointMaskEntry(String type) {
        switch (type) {
            case "none": {
                return JointMaskEntry.NONE;
            }
            case "arms": {
                return JointMaskEntry.BIPED_ARMS;
            }
            case "upper_joints": {
                return JointMaskEntry.BIPED_UPPER_JOINTS;
            }
            case "root_upper_joints": {
                return JointMaskEntry.BIPED_UPPER_JOINTS_WITH_ROOT;
            }
            case "wings": {
                return JointMaskEntry.WINGS;
            }
        }
        return JointMaskEntry.NONE;
    }

    static class Deserializer
    implements JsonDeserializer<AnimationDataReader> {
        Deserializer() {
        }

        public AnimationDataReader deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Layer.LayerType layerType;
            JsonObject jsonObject = json.getAsJsonObject();
            JointMaskEntry.Builder builder = JointMaskEntry.builder();
            Layer.Priority priority = jsonObject.has("priority") ? Layer.Priority.valueOf(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"priority")) : Layer.Priority.LOWEST;
            Layer.LayerType layerType2 = layerType = jsonObject.has("layer") ? Layer.LayerType.valueOf(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"layer")) : Layer.LayerType.BASE_LAYER;
            if (jsonObject.has("masks")) {
                builder.defaultMask(JointMaskEntry.NONE);
                JsonArray maskArray = jsonObject.get("masks").getAsJsonArray();
                maskArray.forEach(element -> {
                    JsonObject jointMaskEntry = element.getAsJsonObject();
                    String livingMotionName = JSONUtils.func_151200_h((JsonObject)jointMaskEntry, (String)"livingmotion");
                    if (livingMotionName.equals("ALL")) {
                        builder.defaultMask(AnimationDataReader.getJointMaskEntry(JSONUtils.func_151200_h((JsonObject)jointMaskEntry, (String)"type")));
                    } else {
                        LivingMotion livingMotion = LivingMotion.ENUM_MANAGER.get(livingMotionName);
                        builder.mask(livingMotion, AnimationDataReader.getJointMaskEntry(JSONUtils.func_151200_h((JsonObject)jointMaskEntry, (String)"type")));
                    }
                });
            }
            return new AnimationDataReader(builder.create(), priority, layerType);
        }
    }
}

