/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.gameasset.Models;

public class ClientModels
extends Models<ClientModel>
implements IFutureReloadListener {
    public static final ClientModels LOGICAL_CLIENT = new ClientModels();
    public final ClientModel playerFirstPerson;
    public final ClientModel playerFirstPersonAlex;
    public final ClientModel drownedOuterLayer;
    public final ClientModel endermanEye;
    public final ClientModel spiderEye;
    public final ClientModel helmet;
    public final ClientModel chestplate;
    public final ClientModel leggins;
    public final ClientModel boots;
    public final ClientModel forceField;
    public final ClientModel laser;

    public ClientModels() {
        this.biped = this.register(new ResourceLocation("epicfight", "entity/biped"));
        this.bipedOldTexture = this.register(new ResourceLocation("epicfight", "entity/biped_old_texture"));
        this.bipedAlex = this.register(new ResourceLocation("epicfight", "entity/biped_slim_arm"));
        this.villagerZombie = this.register(new ResourceLocation("epicfight", "entity/zombie_villager"));
        this.villagerZombieBody = this.register(new ResourceLocation("epicfight", "entity/zombie_villager_body"));
        this.creeper = this.register(new ResourceLocation("epicfight", "entity/creeper"));
        this.enderman = this.register(new ResourceLocation("epicfight", "entity/enderman"));
        this.skeleton = this.register(new ResourceLocation("epicfight", "entity/skeleton"));
        this.spider = this.register(new ResourceLocation("epicfight", "entity/spider"));
        this.ironGolem = this.register(new ResourceLocation("epicfight", "entity/iron_golem"));
        this.illager = this.register(new ResourceLocation("epicfight", "entity/illager"));
        this.witch = this.register(new ResourceLocation("epicfight", "entity/witch"));
        this.ravager = this.register(new ResourceLocation("epicfight", "entity/ravager"));
        this.vex = this.register(new ResourceLocation("epicfight", "entity/vex"));
        this.piglin = this.register(new ResourceLocation("epicfight", "entity/piglin"));
        this.hoglin = this.register(new ResourceLocation("epicfight", "entity/hoglin"));
        this.playerFirstPerson = this.register(new ResourceLocation("epicfight", "entity/biped_firstperson"));
        this.playerFirstPersonAlex = this.register(new ResourceLocation("epicfight", "entity/biped_firstperson_slim"));
        this.drownedOuterLayer = this.register(new ResourceLocation("epicfight", "entity/biped_outer_layer"));
        this.endermanEye = this.register(new ResourceLocation("epicfight", "entity/enderman_face"));
        this.spiderEye = this.register(new ResourceLocation("epicfight", "entity/spider_face"));
        this.dragon = this.register(new ResourceLocation("epicfight", "entity/dragon"));
        this.wither = this.register(new ResourceLocation("epicfight", "entity/wither"));
        this.helmet = this.register(new ResourceLocation("epicfight", "armor/helmet_default"));
        this.chestplate = this.register(new ResourceLocation("epicfight", "armor/chestplate_default"));
        this.leggins = this.register(new ResourceLocation("epicfight", "armor/leggings_default"));
        this.boots = this.register(new ResourceLocation("epicfight", "armor/boots_default"));
        this.forceField = this.register(new ResourceLocation("epicfight", "particle/force_field"));
        this.laser = this.register(new ResourceLocation("epicfight", "particle/laser"));
    }

    @Override
    public ClientModel register(ResourceLocation rl) {
        ClientModel model = new ClientModel(rl);
        this.register(rl, model);
        return model;
    }

    public void register(ResourceLocation rl, ClientModel model) {
        this.models.put(rl, model);
    }

    public void loadModels(IResourceManager resourceManager) {
        ArrayList emptyResourceLocations = Lists.newArrayList();
        this.models.entrySet().forEach(entry -> {
            if (!((ClientModel)entry.getValue()).loadMeshAndProperties(resourceManager)) {
                emptyResourceLocations.add(entry.getKey());
            }
        });
        emptyResourceLocations.forEach(this.models::remove);
    }

    @Override
    public Models<?> getModels(boolean isLogicalClient) {
        return isLogicalClient ? LOGICAL_CLIENT : LOGICAL_SERVER;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            this.loadModels(resourceManager);
            this.loadArmatures(resourceManager);
        }, gameExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
    }
}

