/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.api.utils.math.Vec4f;

@OnlyIn(value=Dist.CLIENT)
public class Mesh {
    final float[] positions;
    final float[] uvs;
    final float[] noramls;
    final float[] weights;
    final List<VertexIndicator> vertexIndicators;

    public Mesh(float[] positions, float[] noramls, float[] uvs, int[] animationIndices, float[] weights, int[] drawingIndices, int[] vCounts) {
        this.positions = positions;
        this.noramls = noramls;
        this.uvs = uvs;
        this.weights = weights;
        this.vertexIndicators = VertexIndicator.create(drawingIndices, vCounts, animationIndices);
    }

    public JsonObject toJsonObject() {
        int i2;
        int k;
        int i3;
        JsonObject root = new JsonObject();
        JsonObject vertices = new JsonObject();
        float[] positions = (float[])this.positions.clone();
        float[] normals = (float[])this.noramls.clone();
        OpenMatrix4f toBlenderCoord = OpenMatrix4f.createRotatorDeg(90.0f, Vec3f.X_AXIS);
        for (i3 = 0; i3 < positions.length / 3; ++i3) {
            k = i3 * 3;
            Vec4f posVector = new Vec4f(positions[k], positions[k + 1], positions[k + 2], 1.0f);
            OpenMatrix4f.transform(toBlenderCoord, posVector, posVector);
            positions[k] = posVector.x;
            positions[k + 1] = posVector.y;
            positions[k + 2] = posVector.z;
        }
        for (i3 = 0; i3 < normals.length / 3; ++i3) {
            k = i3 * 3;
            Vec4f normVector = new Vec4f(normals[k], normals[k + 1], normals[k + 2], 1.0f);
            OpenMatrix4f.transform(toBlenderCoord, normVector, normVector);
            normals[k] = normVector.x;
            normals[k + 1] = normVector.y;
            normals[k + 2] = normVector.z;
        }
        int count = this.vertexIndicators.size();
        int[] indices = new int[count * 3];
        int[] vcounts = new int[positions.length / 3];
        ArrayList vIndexList = Lists.newArrayList();
        HashMap positionMap = Maps.newHashMap();
        for (i2 = 0; i2 < this.vertexIndicators.size(); ++i2) {
            VertexIndicator vertexIndicator = this.vertexIndicators.get(i2);
            indices[i2 * 3] = vertexIndicator.position;
            indices[i2 * 3 + 1] = vertexIndicator.uv;
            indices[i2 * 3 + 2] = vertexIndicator.normal;
            vcounts[vertexIndicator.position] = vertexIndicator.joint.size();
            positionMap.put(vertexIndicator.position, vertexIndicator);
        }
        for (i2 = 0; i2 < vcounts.length; ++i2) {
            for (int j = 0; j < vcounts[i2]; ++j) {
                VertexIndicator vi = (VertexIndicator)positionMap.get(i2);
                vIndexList.add(vi.joint.get(j));
                vIndexList.add(vi.weight.get(j));
            }
        }
        int[] vIndices = vIndexList.stream().mapToInt(i -> i).toArray();
        vertices.add("positions", (JsonElement)Mesh.arrayToJsonObject(positions, 3));
        vertices.add("uvs", (JsonElement)Mesh.arrayToJsonObject(this.uvs, 2));
        vertices.add("normals", (JsonElement)Mesh.arrayToJsonObject(normals, 3));
        vertices.add("indices", (JsonElement)Mesh.arrayToJsonObject(indices, 3));
        vertices.add("vcounts", (JsonElement)Mesh.arrayToJsonObject(vcounts, 1));
        vertices.add("weights", (JsonElement)Mesh.arrayToJsonObject(this.weights, 1));
        vertices.add("vindices", (JsonElement)Mesh.arrayToJsonObject(vIndices, 1));
        root.add("vertices", (JsonElement)vertices);
        return root;
    }

    public static JsonObject arrayToJsonObject(float[] array, int stride) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stride", (Number)stride);
        jsonObject.addProperty("count", (Number)(array.length / stride));
        JsonArray jsonArray = new JsonArray();
        for (float element : array) {
            jsonArray.add((Number)Float.valueOf(element));
        }
        jsonObject.add("array", (JsonElement)jsonArray);
        return jsonObject;
    }

    public static JsonObject arrayToJsonObject(int[] array, int stride) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("stride", (Number)stride);
        jsonObject.addProperty("count", (Number)(array.length / stride));
        JsonArray jsonArray = new JsonArray();
        for (int element : array) {
            jsonArray.add((Number)element);
        }
        jsonObject.add("array", (JsonElement)jsonArray);
        return jsonObject;
    }
}

