/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;

public class LineCollider
extends Collider {
    protected Vector3d modelVec;
    protected Vector3d worldVec;

    public LineCollider(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        this(LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ), posX, posY, posZ, vecX, vecY, vecZ);
    }

    public LineCollider(AxisAlignedBB outerAxisAlignedBB, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(new Vector3d(posX, posY, posZ), outerAxisAlignedBB);
        this.modelVec = new Vector3d(vecX, vecY, vecZ);
        this.worldVec = new Vector3d(0.0, 0.0, 0.0);
    }

    static AxisAlignedBB getInitialAABB(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        Vector3d start = new Vector3d(posX, posY, posZ);
        Vector3d end = new Vector3d(vecX + posX, vecY + posY, vecZ + posZ);
        double length = Math.max(start.func_72433_c(), end.func_72433_c());
        return new AxisAlignedBB(length, length, length, -length, -length, -length);
    }

    @Override
    public void transform(OpenMatrix4f mat) {
        this.worldVec = OpenMatrix4f.transform(mat.removeTranslation(), this.modelVec);
        super.transform(mat);
    }

    @Override
    public boolean isCollide(Entity entity) {
        double endZ;
        double endY;
        double maxStart;
        double minEnd;
        double temp;
        double endX;
        AxisAlignedBB opponent = entity.func_174813_aQ();
        if (this.worldVec.field_72450_a == 0.0 && (this.worldCenter.field_72450_a < opponent.field_72340_a || this.worldCenter.field_72450_a > opponent.field_72336_d)) {
            return false;
        }
        double startX = MathHelper.func_151237_a((double)((opponent.field_72340_a + this.worldCenter.field_72450_a) / -this.worldVec.field_72450_a), (double)0.0, (double)1.0);
        if (startX > (endX = MathHelper.func_151237_a((double)((opponent.field_72336_d + this.worldCenter.field_72450_a) / -this.worldVec.field_72450_a), (double)0.0, (double)1.0))) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if ((minEnd = endX) == (maxStart = startX)) {
            return false;
        }
        if (this.worldVec.field_72448_b == 0.0 && (this.worldCenter.field_72448_b < opponent.field_72338_b || this.worldCenter.field_72448_b > opponent.field_72337_e)) {
            return false;
        }
        double startY = MathHelper.func_151237_a((double)((double)((float)(opponent.field_72338_b - this.worldCenter.field_72448_b)) / this.worldVec.field_72448_b), (double)0.0, (double)1.0);
        if (startY > (endY = MathHelper.func_151237_a((double)((double)((float)(opponent.field_72337_e - this.worldCenter.field_72448_b)) / this.worldVec.field_72448_b), (double)0.0, (double)1.0))) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        maxStart = maxStart < startY ? startY : maxStart;
        double d = minEnd = minEnd > endY ? endY : minEnd;
        if (maxStart >= minEnd) {
            return false;
        }
        if (this.worldVec.field_72449_c == 0.0 && (this.worldCenter.field_72449_c < opponent.field_72339_c || this.worldCenter.field_72449_c > opponent.field_72334_f)) {
            return false;
        }
        double startZ = MathHelper.func_151237_a((double)((double)((float)(opponent.field_72339_c + this.worldCenter.field_72449_c)) / -this.worldVec.field_72449_c), (double)0.0, (double)1.0);
        if (startZ > (endZ = MathHelper.func_151237_a((double)((double)((float)(opponent.field_72334_f + this.worldCenter.field_72449_c)) / -this.worldVec.field_72449_c), (double)0.0, (double)1.0))) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        maxStart = maxStart < startZ ? startZ : maxStart;
        double d2 = minEnd = minEnd > endZ ? endZ : minEnd;
        return !(maxStart >= minEnd);
    }

    @Override
    public void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, OpenMatrix4f pose, boolean red) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(EpicFightRenderTypes.debugCollider());
        OpenMatrix4f transpose = new OpenMatrix4f();
        OpenMatrix4f.transpose(pose, transpose);
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        float startX = (float)this.modelCenter.field_72450_a;
        float startY = (float)this.modelCenter.field_72448_b;
        float startZ = (float)this.modelCenter.field_72449_c;
        float endX = (float)(this.modelCenter.field_72450_a + this.modelVec.field_72450_a);
        float endY = (float)(this.modelCenter.field_72448_b + this.modelVec.field_72448_b);
        float endZ = (float)(this.modelCenter.field_72449_c + this.modelVec.field_72449_c);
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
    }
}

