/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.LineCollider;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MultiLineCollider
extends MultiCollider<LineCollider> {
    public MultiLineCollider(int arrayLength, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(arrayLength, posX, posY, posZ, LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
        this.bigCollider = new LineCollider(this.outerAABB, posX, posY, posZ, vecX, vecY, vecZ);
    }

    @Override
    public LineCollider createCollider() {
        return new LineCollider(this.outerAABB, this.modelCenter.field_72450_a, this.modelCenter.field_72448_b, this.modelCenter.field_72449_c, ((LineCollider)this.bigCollider).modelVec.field_72450_a, ((LineCollider)this.bigCollider).modelVec.field_72448_b, ((LineCollider)this.bigCollider).modelVec.field_72449_c);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        float partialScale;
        int numberOf = Math.max(Math.round((float)this.numberOfColliders * attackSpeed), 1);
        float interpolation = partialScale = 1.0f / (float)numberOf;
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(animation.getPathIndexByTime(elapsedTime));
        boolean red = entitypatch.getEntityState().attacking();
        ArrayList colliders = Lists.newArrayList();
        for (int i = 0; i < numberOf; ++i) {
            colliders.add(this.createCollider());
        }
        for (LineCollider lineCollider : colliders) {
            matrixStackIn.func_227860_a_();
            OpenMatrix4f mat = null;
            float partialTime = MathHelper.func_219799_g((float)interpolation, (float)prevElapsedTime, (float)elapsedTime);
            mat = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(animation.getPoseByTime(entitypatch, partialTime, 0.0f), armature, pathIndex);
            lineCollider.drawInternal(matrixStackIn, buffer, mat, red);
            interpolation += partialScale;
            matrixStackIn.func_227865_b_();
        }
    }
}

