/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PlaneCollider
extends Collider {
    private Vector3d[] modelPos;
    private Vector3d[] worldPos;

    public PlaneCollider(Vector3d center, AxisAlignedBB entityCallAABB) {
        super(center, entityCallAABB);
    }

    public PlaneCollider(AxisAlignedBB entityCallAABB, double centerX, double centerY, double centerZ, double pos1X, double pos1Y, double pos1Z, double pos2X, double pos2Y, double pos2Z) {
        super(new Vector3d(centerX, centerY, centerZ), entityCallAABB);
        this.modelPos = new Vector3d[2];
        this.worldPos = new Vector3d[2];
        this.modelPos[0] = new Vector3d(pos1X, pos1Y, pos1Z);
        this.modelPos[1] = new Vector3d(pos2X, pos2Y, pos2Z);
        this.worldPos[0] = new Vector3d(0.0, 0.0, 0.0);
        this.worldPos[1] = new Vector3d(0.0, 0.0, 0.0);
    }

    @Override
    public boolean isCollide(Entity entity) {
        AxisAlignedBB opponent = entity.func_174813_aQ();
        Vector3d planeNorm = this.worldPos[0].func_72431_c(this.worldPos[1]);
        Vector3d pos = new Vector3d(planeNorm.field_72450_a >= 0.0 ? opponent.field_72336_d : opponent.field_72340_a, planeNorm.field_72448_b >= 0.0 ? opponent.field_72337_e : opponent.field_72338_b, planeNorm.field_72449_c >= 0.0 ? opponent.field_72334_f : opponent.field_72339_c);
        Vector3d neg = new Vector3d(planeNorm.field_72450_a >= 0.0 ? opponent.field_72340_a : opponent.field_72336_d, planeNorm.field_72448_b >= 0.0 ? opponent.field_72338_b : opponent.field_72337_e, planeNorm.field_72449_c >= 0.0 ? opponent.field_72339_c : opponent.field_72334_f);
        double planeD = planeNorm.func_72430_b(this.worldCenter);
        double dot1 = planeNorm.func_72430_b(pos) - planeD;
        if (dot1 < 0.0) {
            return false;
        }
        double dot2 = planeNorm.func_72430_b(neg) - planeD;
        return !(dot2 > 0.0);
    }

    @Override
    public void transform(OpenMatrix4f mat) {
        for (int i = 0; i < 2; ++i) {
            this.worldPos[i] = OpenMatrix4f.transform(mat.removeTranslation(), this.modelPos[i]);
        }
        super.transform(mat);
    }

    @Override
    public void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, OpenMatrix4f pose, boolean red) {
    }

    @Override
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
    }
}

