/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils.math;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

public class MathUtils {
    public static OpenMatrix4f getModelMatrixIntegral(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw, float partialTick, float scaleX, float scaleY, float scaleZ) {
        OpenMatrix4f modelMatrix = new OpenMatrix4f();
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        float pitchDegree = MathUtils.lerpBetween(prevPitch, pitch, partialTick);
        float yawDegree = MathUtils.lerpBetween(prevYaw, yaw, partialTick);
        modelMatrix.translate(entityPosition).rotateDeg(-yawDegree, Vec3f.Y_AXIS).rotateDeg(-pitchDegree, Vec3f.X_AXIS).scale(scaleX, scaleY, scaleZ);
        return modelMatrix;
    }

    public static Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float lerpBetween(float f1, float f2, float zero2one) {
        float f = 0.0f;
        for (f = f2 - f1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return f1 + zero2one * f;
    }

    public static float rotlerp(float from, float to, float limit) {
        float f1;
        float f = MathHelper.func_76142_g((float)(to - from));
        if (f > limit) {
            f = limit;
        }
        if (f < -limit) {
            f = -limit;
        }
        for (f1 = from + f; f1 >= 180.0f; f1 -= 360.0f) {
        }
        while (f1 <= -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static void translateStack(MatrixStack mStack, OpenMatrix4f mat) {
        Vector3f vector = new Vector3f(mat.m30, mat.m31, mat.m32);
        mStack.func_227861_a_((double)vector.func_195899_a(), (double)vector.func_195900_b(), (double)vector.func_195902_c());
    }

    public static void rotateStack(MatrixStack mStack, OpenMatrix4f mat) {
        mStack.func_227863_a_(MathUtils.getQuaternionFromMatrix(mat));
    }

    public static void scaleStack(MatrixStack mStack, OpenMatrix4f mat) {
        Vector3f vector = MathUtils.getScaleVectorFromMatrix(mat);
        mStack.func_227862_a_(vector.func_195899_a(), vector.func_195900_b(), vector.func_195902_c());
    }

    public static double getAngleBetween(Vec3f a, Vec3f b) {
        double cos = a.x * b.x + a.y * b.y + a.z * b.z;
        return Math.acos(cos);
    }

    private static Quaternion getQuaternionFromMatrix(OpenMatrix4f mat) {
        float z;
        float y;
        float x;
        float w;
        float diagonal = mat.m00 + mat.m11 + mat.m22;
        if (diagonal > 0.0f) {
            float w4 = (float)(Math.sqrt(diagonal + 1.0f) * 2.0);
            w = w4 * 0.25f;
            x = (mat.m21 - mat.m12) / w4;
            y = (mat.m02 - mat.m20) / w4;
            z = (mat.m10 - mat.m01) / w4;
        } else if (mat.m00 > mat.m11 && mat.m00 > mat.m22) {
            float x4 = (float)(Math.sqrt(1.0f + mat.m00 - mat.m11 - mat.m22) * 2.0);
            w = (mat.m21 - mat.m12) / x4;
            x = x4 * 0.25f;
            y = (mat.m01 + mat.m10) / x4;
            z = (mat.m02 + mat.m20) / x4;
        } else if (mat.m11 > mat.m22) {
            float y4 = (float)(Math.sqrt(1.0f + mat.m11 - mat.m00 - mat.m22) * 2.0);
            w = (mat.m02 - mat.m20) / y4;
            x = (mat.m01 + mat.m10) / y4;
            y = y4 * 0.25f;
            z = (mat.m12 + mat.m21) / y4;
        } else {
            float z4 = (float)(Math.sqrt(1.0f + mat.m22 - mat.m00 - mat.m11) * 2.0);
            w = (mat.m10 - mat.m01) / z4;
            x = (mat.m02 + mat.m20) / z4;
            y = (mat.m12 + mat.m21) / z4;
            z = z4 * 0.25f;
        }
        Quaternion quat = new Quaternion(x, y, z, w);
        quat.func_227067_f_();
        return quat;
    }

    public static Vec3f lerpVector(Vec3f start, Vec3f end, float weight) {
        float x = start.x + (end.x - start.x) * weight;
        float y = start.y + (end.y - start.y) * weight;
        float z = start.z + (end.z - start.z) * weight;
        return new Vec3f(x, y, z);
    }

    public static Vector3d projectVector(Vector3d from, Vector3d to) {
        double dot = to.func_72430_b(from);
        double normalScale = 1.0 / (to.field_72450_a * to.field_72450_a + to.field_72448_b * to.field_72448_b + to.field_72449_c * to.field_72449_c);
        return new Vector3d(dot * to.field_72450_a * normalScale, dot * to.field_72448_b * normalScale, dot * to.field_72449_c * normalScale);
    }

    public static void setQuaternion(Quaternion quat, float x, float y, float z, float w) {
        quat.field_227061_b_ = x;
        quat.field_227062_c_ = y;
        quat.field_227063_d_ = z;
        quat.field_227064_e_ = w;
    }

    public static Quaternion mulQuaternion(Quaternion left, Quaternion right, Quaternion dest) {
        if (dest == null) {
            dest = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        }
        float f = left.func_195889_a();
        float f1 = left.func_195891_b();
        float f2 = left.func_195893_c();
        float f3 = left.func_195894_d();
        float f4 = right.func_195889_a();
        float f5 = right.func_195891_b();
        float f6 = right.func_195893_c();
        float f7 = right.func_195894_d();
        float i = f3 * f4 + f * f7 + f1 * f6 - f2 * f5;
        float j = f3 * f5 - f * f6 + f1 * f7 + f2 * f4;
        float k = f3 * f6 + f * f5 - f1 * f4 + f2 * f7;
        float r = f3 * f7 - f * f4 - f1 * f5 - f2 * f6;
        MathUtils.setQuaternion(dest, i, j, k, r);
        return dest;
    }

    public static double horizontalDistance(Vector3d vec) {
        return Math.sqrt(MathUtils.horizontalDistanceSqr(vec));
    }

    public static double horizontalDistanceSqr(Vector3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c;
    }

    public static Quaternion quaternionFromDegree(Vector3f axis, float degree) {
        return new Quaternion(axis, degree, true);
    }

    public static Quaternion lerpQuaternion(Quaternion from, Quaternion to, float weight) {
        float resultZ;
        float resultY;
        float resultX;
        float resultW;
        float fromX = from.func_195889_a();
        float fromY = from.func_195891_b();
        float fromZ = from.func_195893_c();
        float fromW = from.func_195894_d();
        float toX = to.func_195889_a();
        float toY = to.func_195891_b();
        float toZ = to.func_195893_c();
        float toW = to.func_195894_d();
        float dot = fromW * toW + fromX * toX + fromY * toY + fromZ * toZ;
        float blendI = 1.0f - weight;
        if (dot < 0.0f) {
            resultW = blendI * fromW + weight * -toW;
            resultX = blendI * fromX + weight * -toX;
            resultY = blendI * fromY + weight * -toY;
            resultZ = blendI * fromZ + weight * -toZ;
        } else {
            resultW = blendI * fromW + weight * toW;
            resultX = blendI * fromX + weight * toX;
            resultY = blendI * fromY + weight * toY;
            resultZ = blendI * fromZ + weight * toZ;
        }
        Quaternion result = new Quaternion(resultX, resultY, resultZ, resultW);
        MathUtils.normalizeQuaternion(result);
        return result;
    }

    private static void normalizeQuaternion(Quaternion quaternion) {
        float f = quaternion.func_195889_a() * quaternion.func_195889_a() + quaternion.func_195891_b() * quaternion.func_195891_b() + quaternion.func_195893_c() * quaternion.func_195893_c() + quaternion.func_195894_d() * quaternion.func_195894_d();
        if (f > 1.0E-6f) {
            float f1 = MathUtils.fastInvSqrt(f);
            MathUtils.setQuaternion(quaternion, quaternion.func_195889_a() * f1, quaternion.func_195891_b() * f1, quaternion.func_195893_c() * f1, quaternion.func_195894_d() * f1);
        } else {
            MathUtils.setQuaternion(quaternion, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private static Vector3f getScaleVectorFromMatrix(OpenMatrix4f mat) {
        Vec3f a = new Vec3f(mat.m00, mat.m10, mat.m20);
        Vec3f b = new Vec3f(mat.m01, mat.m11, mat.m21);
        Vec3f c = new Vec3f(mat.m02, mat.m12, mat.m22);
        return new Vector3f(a.length(), b.length(), c.length());
    }

    private static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }
}

