/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.UseAction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.provider.ProviderEntity;
import yesman.epicfight.world.capabilities.provider.ProviderItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
public class ClientEvents {
    private static final Pair<ResourceLocation, ResourceLocation> OFFHAND_TEXTURE = Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
    private static Minecraft minecraft = Minecraft.func_71410_x();

    @SubscribeEvent
    public static void mouseClickEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getGui() instanceof ContainerScreen && (slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.field_71439_g.field_71071_by.func_70445_o())).canBePlacedOffhand() && slot.func_225517_c_() != null && slot.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void mouseReleaseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getGui() instanceof ContainerScreen && (slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.field_71439_g.field_71071_by.func_70445_o())).canBePlacedOffhand() && slot.func_225517_c_() != null && slot.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void presssKeyInGui(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        Slot slot;
        CapabilityItem itemCapability = CapabilityItem.EMPTY;
        if (event.getKeyCode() == ClientEvents.minecraft.field_71474_y.field_186718_X.getKey().func_197937_c()) {
            Slot slot2;
            if (event.getGui() instanceof ContainerScreen && (slot2 = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot2.func_75216_d() && !(itemCapability = EpicFightCapabilities.getItemStackCapability(slot2.func_75211_c())).canBePlacedOffhand()) {
                event.setCanceled(true);
            }
        } else if (event.getKeyCode() >= 49 && event.getKeyCode() <= 57 && event.getGui() instanceof ContainerScreen && (slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot.func_225517_c_() != null && slot.func_225517_c_().equals(OFFHAND_TEXTURE) && !(itemCapability = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.field_71439_g.field_71071_by.func_70301_a(event.getKeyCode() - 49))).canBePlacedOffhand()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void rightClickItemClient(PlayerInteractEvent.RightClickItem event) {
        LocalPlayerPatch playerpatch;
        if (event.getSide() == LogicalSide.CLIENT && (playerpatch = (LocalPlayerPatch)event.getPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) != null && ((ClientPlayerEntity)playerpatch.getOriginal()).func_184592_cb().func_77975_n() == UseAction.NONE) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, new RightClickItemEvent<LocalPlayerPatch>(playerpatch));
            if (playerpatch.getEntityState().movementLocked()) {
                canceled = true;
            }
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void clientRespawnEvent(ClientPlayerNetworkEvent.RespawnEvent event) {
        LocalPlayerPatch oldCap = (LocalPlayerPatch)event.getOldPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (oldCap != null) {
            LocalPlayerPatch newCap = (LocalPlayerPatch)event.getNewPlayer().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            newCap.onRespawnLocalPlayer(event);
            newCap.copySkillsFrom(oldCap);
            newCap.toMode(oldCap.getPlayerMode(), false);
        }
    }

    @SubscribeEvent
    public static void clientLogoutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (event.getPlayer() != null) {
            ItemCapabilityReloadListener.reset();
            ProviderItem.clear();
            ProviderEntity.clear();
            ClientEngine.instance.renderEngine.clearCustomEntityRenerer();
        }
    }
}

