/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

@OnlyIn(value=Dist.CLIENT)
public class HealthBarIndicator
extends EntityIndicator {
    @Override
    public boolean shouldDraw(ClientPlayerEntity player, LivingEntity entityIn) {
        if (!EpicFightMod.CLIENT_INGAME_CONFIG.showHealthIndicator.getValue().booleanValue()) {
            return false;
        }
        if (!entityIn.func_184222_aU() || entityIn.func_82150_aj() || entityIn == player.func_184187_bx()) {
            return false;
        }
        if (entityIn.func_70068_e(Minecraft.func_71410_x().func_175606_aa()) >= 400.0) {
            return false;
        }
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)entityIn;
            if (playerIn == player) {
                return false;
            }
            if (playerIn.func_184812_l_() || playerIn.func_175149_v()) {
                return false;
            }
        }
        return !(entityIn.func_70651_bq().isEmpty() && entityIn.func_110143_aJ() >= entityIn.func_110138_aP()) && entityIn.field_70725_aQ < 19;
    }

    @Override
    public void drawIndicator(LivingEntity entityIn, MatrixStack matStackIn, IRenderTypeBuffer bufferIn, float partialTicks) {
        EntityPatch entitypatch;
        Matrix4f mvMatrix = super.getMVMatrix(matStackIn, entityIn, 0.0f, entityIn.func_213302_cg() + 0.25f, 0.0f, true, partialTicks);
        Collection activeEffects = entityIn.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    Effect effect = ((EffectInstance)iter.next()).func_188419_a();
                    ResourceLocation rl = effect instanceof VisibleMobEffect ? ((VisibleMobEffect)effect).getIcon() : new ResourceLocation(effect.getRegistryName().func_110624_b(), "textures/mob_effect/" + effect.getRegistryName().func_110623_a() + ".png");
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    IVertexBuilder vertexBuilder1 = bufferIn.getBuffer(EpicFightRenderTypes.entityIndicator(rl));
                    this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder1, x, y, x + 0.3f, y + 0.3f, 0.0f, 0.0f, 256.0f, 256.0f);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(EpicFightRenderTypes.entityIndicator(BATTLE_ICON));
        float ratio = entityIn.func_110143_aJ() / entityIn.func_110138_aP();
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, healthRatio, 0.05f, 1.0f, 15.0f, textureRatio, 20.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, healthRatio, -0.05f, 0.5f, 0.05f, textureRatio, 10.0f, 62.0f, 15.0f);
        float absorption = entityIn.func_110139_bj();
        if ((double)absorption > 0.0) {
            float absorptionRatio = absorption / entityIn.func_110138_aP();
            int absTexRatio = (int)(62.0f * absorptionRatio);
            this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, absorptionRatio - 0.5f, 0.05f, 1.0f, 20.0f, absTexRatio, 25.0f);
        }
        if ((entitypatch = (EntityPatch)entityIn.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null && entitypatch instanceof LivingEntityPatch) {
            this.renderStunShield((LivingEntityPatch)entitypatch, mvMatrix, vertexBuilder);
        }
    }

    private void renderStunShield(LivingEntityPatch<?> entitypatch, Matrix4f mvMatrix, IVertexBuilder vertexBuilder) {
        if (entitypatch.getStunShield() == 0.0f) {
            return;
        }
        float ratio = entitypatch.getStunShield() / entitypatch.getStunArmor();
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.1f, barRatio, -0.05f, 1.0f, 5.0f, textureRatio, 10.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, barRatio, -0.1f, 0.5f, -0.05f, textureRatio, 0.0f, 63.0f, 5.0f);
    }
}

