/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.EditItemListScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.provider.ProviderItem;

@OnlyIn(value=Dist.CLIENT)
public class EditSwitchingItemScreen
extends Screen {
    private RegisteredItemList battleAutoSwitchItems;
    private RegisteredItemList miningAutoSwitchItems;
    protected final Screen parentScreen;
    private Runnable deferredTooltip;

    public EditSwitchingItemScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("epicfight.gui.configuration.autoswitching"));
        this.parentScreen = parentScreen;
    }

    protected void func_231160_c_() {
        if (this.battleAutoSwitchItems == null) {
            this.battleAutoSwitchItems = new RegisteredItemList(this.field_230706_i_, 200, this.field_230709_l_, (ITextComponent)new TranslationTextComponent("epicfight.gui.to_battle_mode"), EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems);
        } else {
            this.battleAutoSwitchItems.resize(200, this.field_230709_l_);
        }
        if (this.miningAutoSwitchItems == null) {
            this.miningAutoSwitchItems = new RegisteredItemList(this.field_230706_i_, 200, this.field_230709_l_, (ITextComponent)new TranslationTextComponent("epicfight.gui.to_mining_mode"), EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems);
        } else {
            this.miningAutoSwitchItems.resize(200, this.field_230709_l_);
        }
        this.battleAutoSwitchItems.func_230959_g_(this.field_230708_k_ / 2 - 204);
        this.miningAutoSwitchItems.func_230959_g_(this.field_230708_k_ / 2 + 4);
        this.field_230705_e_.add(this.battleAutoSwitchItems);
        this.field_230705_e_.add(this.miningAutoSwitchItems);
        this.field_230705_e_.add(new Button(this.field_230708_k_ / 2 - 80, this.field_230709_l_ - 28, 160, 20, DialogTexts.field_240632_c_, button -> {
            EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems.clear();
            EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems.clear();
            this.battleAutoSwitchItems.toList().forEach(item -> EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems.add((Item)item));
            this.miningAutoSwitchItems.toList().forEach(item -> EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems.add((Item)item));
            EpicFightMod.CLIENT_INGAME_CONFIG.save();
            this.func_231175_as__();
        }));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        this.battleAutoSwitchItems.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.miningAutoSwitchItems.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        EditSwitchingItemScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        if (this.deferredTooltip != null) {
            this.deferredTooltip.run();
            this.deferredTooltip = null;
        }
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegisteredItemList
    extends ExtendedList<ItemEntry> {
        private final ITextComponent title;

        public RegisteredItemList(Minecraft mcIn, int width, int height, ITextComponent title, List<Item> saved) {
            super(mcIn, width, height, 32, height - 50, 22);
            this.title = title;
            this.func_230944_a_(true, 13);
            if (this.func_230958_g_() != null) {
                this.func_230951_c_(this.func_230958_g_());
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new ButtonInEntry());
            for (Item item : saved) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new ItemEntry(item));
            }
        }

        public void resize(int width, int height) {
            this.field_230670_d_ = width;
            this.field_230671_e_ = height;
            this.field_230672_i_ = 32;
            this.field_230673_j_ = height - 50;
            this.field_230675_l_ = 0;
            this.field_230674_k_ = width;
        }

        protected void func_230448_a_(MatrixStack matrixStack, int x, int y, Tessellator tessellator) {
            IFormattableTextComponent Component = new StringTextComponent("").func_230529_a_(this.title).func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.BOLD});
            this.field_230668_b_.field_71466_p.func_243248_b(matrixStack, (ITextComponent)Component, (float)(x + this.field_230670_d_ / 2 - this.field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)Component) / 2), (float)Math.min(this.field_230672_i_ + 3, y), 0xFFFFFF);
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected int func_230952_d_() {
            return this.field_230674_k_ - 6;
        }

        protected void addEntry(Item item) {
            this.func_231039_at__().add(new ItemEntry(item));
        }

        protected void removeIfPresent(Item item) {
            this.func_231039_at__().remove((Object)new ItemEntry(item));
        }

        protected List<Item> toList() {
            ArrayList list = Lists.newArrayList();
            for (ItemEntry entry : this.func_231039_at__()) {
                if (entry.item == null) continue;
                list.add(entry.item);
            }
            return list;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonInEntry
        extends ItemEntry {
            private Button addItemButton;
            private Button removeAllButton;
            private Button automaticRegisterButton;

            public ButtonInEntry() {
                super(null);
                this.addItemButton = new Button(0, 0, 20, 20, (ITextComponent)new StringTextComponent("+"), button -> {
                    RegisteredItemList thisList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.battleAutoSwitchItems : EditSwitchingItemScreen.this.miningAutoSwitchItems;
                    RegisteredItemList opponentList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.miningAutoSwitchItems : EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    RegisteredItemList.this.field_230668_b_.func_147108_a((Screen)new EditItemListScreen(EditSwitchingItemScreen.this, thisList, opponentList));
                }, Button.field_238486_s_);
                this.removeAllButton = new Button(0, 0, 60, 20, (ITextComponent)new TranslationTextComponent("epicfight.gui.delete_all"), button -> {
                    RegisteredItemList.this.func_230963_j_();
                    RegisteredItemList.this.func_230513_b_((AbstractList.AbstractListEntry)this);
                }, Button.field_238486_s_);
                this.automaticRegisterButton = new Button(0, 0, 60, 20, (ITextComponent)new TranslationTextComponent("epicfight.gui.auto_add"), button -> {
                    boolean isBattleTab;
                    boolean bl = isBattleTab = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    if (isBattleTab) {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            if (!ProviderItem.has(item)) continue;
                            ItemEntry itemEntry = new ItemEntry(item);
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.func_231039_at__().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.battleAutoSwitchItems.func_230513_b_((AbstractList.AbstractListEntry)itemEntry);
                        }
                    } else {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            ItemEntry itemEntry = new ItemEntry(item);
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.func_231039_at__().contains((Object)itemEntry) || EditSwitchingItemScreen.this.miningAutoSwitchItems.func_231039_at__().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.miningAutoSwitchItems.func_230513_b_((AbstractList.AbstractListEntry)itemEntry);
                        }
                    }
                }, (button, matrixStack, mouseX, mouseY) -> {
                    String tooltip;
                    boolean isBattleTab = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    String string = tooltip = isBattleTab ? "epicfight.gui.tooltip_battle" : "epicfight.gui.tooltip_mining";
                    if (isBattleTab) {
                        EditSwitchingItemScreen.this.deferredTooltip = () -> EditSwitchingItemScreen.this.func_238654_b_(matrixStack, ((EditSwitchingItemScreen)EditSwitchingItemScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent(tooltip), Math.max(EditSwitchingItemScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                    } else {
                        EditSwitchingItemScreen.this.func_238654_b_(matrixStack, ((EditSwitchingItemScreen)EditSwitchingItemScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent(tooltip), Math.max(EditSwitchingItemScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                    }
                });
            }

            @Override
            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.addItemButton.field_230690_l_ = left + 25;
                this.addItemButton.field_230691_m_ = top - 2;
                this.addItemButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                this.removeAllButton.field_230690_l_ = left + 47;
                this.removeAllButton.field_230691_m_ = top - 2;
                this.removeAllButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                this.automaticRegisterButton.field_230690_l_ = left + 109;
                this.automaticRegisterButton.field_230691_m_ = top - 2;
                this.automaticRegisterButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }

            @Override
            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (this.addItemButton.func_231047_b_(mouseX, mouseY)) {
                        this.addItemButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                        this.addItemButton.func_230930_b_();
                    }
                    if (this.removeAllButton.func_231047_b_(mouseX, mouseY)) {
                        this.removeAllButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                        this.removeAllButton.func_230930_b_();
                    }
                    if (this.automaticRegisterButton.func_231047_b_(mouseX, mouseY)) {
                        this.automaticRegisterButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                        this.automaticRegisterButton.func_230930_b_();
                    }
                }
                return false;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class ItemEntry
        extends ExtendedList.AbstractListEntry<ItemEntry> {
            private Item item;

            public ItemEntry(Item item) {
                this.item = item;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                try {
                    EditSwitchingItemScreen.this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)this.item), left + 4, top + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ITextComponent Component = this.item.func_200295_i(ItemStack.field_190927_a);
                ((RegisteredItemList)RegisteredItemList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, Component, (float)(left + 30), (float)top + 5.0f, 0xFFFFFF);
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegisteredItemList.this.func_230958_g_() != null && ((ItemEntry)RegisteredItemList.this.func_230958_g_()).equals((Object)this)) {
                        RegisteredItemList.this.func_230956_e_((AbstractList.AbstractListEntry)this);
                        return false;
                    }
                    RegisteredItemList.this.func_241215_a_((AbstractList.AbstractListEntry)this);
                    return true;
                }
                return false;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemEntry && !(this instanceof ButtonInEntry)) {
                    return this.item.equals(((ItemEntry)((Object)obj)).item);
                }
                return super.equals(obj);
            }
        }
    }
}

