/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.item.SkillBookItem;

@OnlyIn(value=Dist.CLIENT)
public class SkillBookScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("epicfight", "textures/gui/screen/skillbook.png");
    private final PlayerEntity opener;
    private final Skill skill;
    private final Hand hand;

    public SkillBookScreen(PlayerEntity opener, ItemStack stack, Hand hand) {
        super(StringTextComponent.field_240750_d_);
        this.opener = opener;
        this.skill = SkillBookItem.getContainSkill(stack);
        this.hand = hand;
    }

    protected void func_231160_c_() {
        LocalPlayerPatch playerpatch = (LocalPlayerPatch)this.opener.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        boolean isUsing = this.skill.equals(playerpatch.getSkill(this.skill.getCategory()).getSkill());
        Skill priorSkill = this.skill.getPriorSkill();
        boolean condition = priorSkill == null ? true : playerpatch.getSkill(priorSkill.getCategory()).getSkill() == priorSkill;
        Button.ITooltip tooltip = Button.field_238486_s_;
        if (!isUsing) {
            if (condition) {
                if (playerpatch.getSkill(this.skill.getCategory()).getSkill() != null) {
                    tooltip = (button, matrixStack, mouseX, mouseY) -> this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.epicfight.replace", new Object[]{new TranslationTextComponent(this.skill.getTranslatableText()).getString()}), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                }
            } else {
                tooltip = (button, matrixStack, mouseX, mouseY) -> this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("gui.epicfight.require_learning", new Object[]{new TranslationTextComponent(priorSkill.getTranslatableText()).getString()}), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
            }
        }
        Button changeButton = new Button((this.field_230708_k_ + 130) / 2, (this.field_230709_l_ + 90) / 2, 46, 20, (ITextComponent)new TranslationTextComponent("gui.epicfight" + (isUsing ? ".applied" : (condition ? ".learn" : ".unusable"))), p_onPress_1_ -> {
            if (playerpatch != null) {
                playerpatch.getSkill(this.skill.getCategory()).setSkill(this.skill);
                this.field_230706_i_.func_147108_a((Screen)null);
                playerpatch.getSkillCapability().addLearnedSkill(this.skill);
                int i = this.hand == Hand.MAIN_HAND ? this.opener.field_71071_by.field_70461_c : 40;
                EpicFightNetworkManager.sendToServer(new CPChangeSkill(this.skill.getCategory().universalOrdinal(), i, this.skill.toString(), false));
            }
        }, tooltip);
        if (isUsing || !condition) {
            changeButton.field_230693_o_ = false;
        }
        this.func_230480_a_((Widget)changeButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        int posX = (this.field_230708_k_ - 250) / 2;
        int posY = (this.field_230709_l_ - 200) / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        this.func_238474_b_(matrixStack, posX, posY, 0, 0, 256, 181);
        this.field_230706_i_.func_110434_K().func_110577_a(this.skill.getSkillTexture());
        RenderSystem.enableBlend();
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)(posX + 25), (int)(posY + 50), (int)50, (int)50, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        RenderSystem.disableBlend();
        String translationName = this.skill.getTranslatableText();
        String skillName = new TranslationTextComponent(translationName).getString();
        int width = this.field_230712_o_.func_78256_a(skillName);
        this.field_230712_o_.func_238421_b_(matrixStack, skillName, (float)(posX + 50 - width / 2), (float)(posY + 115), 0);
        String skillCategory = String.format("(%s)", new TranslationTextComponent("skill.epicfight." + this.skill.getCategory().toString().toLowerCase() + ".category").getString());
        width = this.field_230712_o_.func_78256_a(skillCategory);
        this.field_230712_o_.func_238421_b_(matrixStack, skillCategory, (float)(posX + 50 - width / 2), (float)(posY + 130), 0);
        List list = this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent(translationName + ".tooltip", this.skill.getTooltipArgs().toArray(new Object[0])), 140);
        int height = posY + 20;
        for (int l1 = 0; l1 < list.size(); ++l1) {
            IReorderingProcessor ireorderingprocessor1 = (IReorderingProcessor)list.get(l1);
            if (ireorderingprocessor1 != null) {
                this.field_230712_o_.func_238422_b_(matrixStack, ireorderingprocessor1, (float)(posX + 105), (float)height, 0);
            }
            height += 10;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

