/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.overlay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.overlay.BlendingTextureOverlay;
import yesman.epicfight.client.gui.screen.overlay.FlickeringOverlay;

@OnlyIn(value=Dist.CLIENT)
public class OverlayManager {
    private Map<String, Overlay> overlays = Maps.newHashMap();

    public void renderTick(int xResolution, int yResolution) {
        ArrayList toRemove = Lists.newArrayList();
        for (Map.Entry<String, Overlay> entry : this.overlays.entrySet()) {
            Overlay overlay2 = entry.getValue();
            overlay2.render(xResolution, yResolution);
            if (!overlay2.isRemoved) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.overlays::remove);
        this.overlays.values().forEach(overlay -> overlay.render(xResolution, yResolution));
    }

    public void remove(String overlayId) {
        this.overlays.remove(overlayId);
    }

    public void blendingTexture(String overlayId, ResourceLocation texture) {
        if (Minecraft.func_71382_s()) {
            this.overlays.put(overlayId, new BlendingTextureOverlay(texture));
        }
    }

    public void flickering(String overlayId, float deltaTime, float strength) {
        if (Minecraft.func_71382_s()) {
            this.overlays.put(overlayId, new FlickeringOverlay(deltaTime, strength));
        }
    }

    public static abstract class Overlay {
        protected boolean isRemoved;

        public abstract void render(int var1, int var2);
    }
}

