/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.config.Option;

@OnlyIn(value=Dist.CLIENT)
public class ColorSlider
extends AbstractSlider {
    private static final int[] COLOR_ARRAY = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    private final Option.DoubleOption colorOption;

    public ColorSlider(int x, int y, int width, int height, ITextComponent message, double defaultValue, Option.DoubleOption option) {
        super(x, y, width, height, message, defaultValue);
        this.colorOption = option;
    }

    public void func_230431_b_(MatrixStack PoseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        RenderSystem.enableBlend();
        for (int i = 0; i < 6; ++i) {
            this.func_238468_a_(PoseStack, this.field_230690_l_ + this.field_230688_j_ * i / 6, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_ * (i + 1) / 6, this.field_230691_m_ + this.field_230689_k_, COLOR_ARRAY[i], COLOR_ARRAY[i + 1]);
        }
        this.func_230441_a_(PoseStack, minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        ColorSlider.func_238472_a_((MatrixStack)PoseStack, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
    }

    protected void func_230441_a_(MatrixStack PoseStack, Minecraft minecraft, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(field_230687_i_);
        int i = (this.func_230449_g_() ? 2 : 1) * 20;
        int minX = this.field_230690_l_ + (int)(this.field_230683_b_ * (double)(this.field_230688_j_ - 8));
        this.func_238474_b_(PoseStack, minX, this.field_230691_m_, 0, 46 + i, 4, 20);
        this.func_238474_b_(PoseStack, minX + 4, this.field_230691_m_, 196, 46 + i, 4, 20);
        ColorSlider.func_238467_a_((MatrixStack)PoseStack, (int)(minX + 1), (int)(this.field_230691_m_ + 1), (int)(minX + 7), (int)(this.field_230691_m_ + 19), (int)ColorSlider.toColorInteger(this.field_230683_b_));
    }

    protected void func_230972_a_() {
        this.colorOption.setValue(this.field_230683_b_);
    }

    protected void func_230979_b_() {
    }

    public static int toColorInteger(double value) {
        int packedColor = 0;
        for (int i = 0; i < 6; ++i) {
            double min = 0.16666666666666666 * (double)i;
            double max = 0.16666666666666666 * (double)(i + 1);
            if (!(value >= min) || !(value <= max)) continue;
            double lerpFactor = (value - min) / (max - min);
            int colorA = COLOR_ARRAY[i];
            int colorB = COLOR_ARRAY[i + 1];
            int f = colorA >> 24 & 0xFF;
            int f1 = colorA >> 16 & 0xFF;
            int f2 = colorA >> 8 & 0xFF;
            int f3 = colorA & 0xFF;
            int f4 = colorB >> 24 & 0xFF;
            int f5 = colorB >> 16 & 0xFF;
            int f6 = colorB >> 8 & 0xFF;
            int f7 = colorB & 0xFF;
            int r = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f, (double)f4);
            int g = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f1, (double)f5);
            int b = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f2, (double)f6);
            int a = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f3, (double)f7);
            packedColor = r << 24 | g << 16 | b << 8 | a;
        }
        return packedColor;
    }

    protected void func_238468_a_(MatrixStack poseStack, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        poseStack.func_227860_a_();
        int width = x2 - x1;
        int height = y2 - y1;
        int newX = x1 + width / 2;
        int newY = y1 + height / 2;
        poseStack.func_227861_a_((double)newX, (double)newY, 0.0);
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
        super.func_238468_a_(poseStack, -height / 2, -width / 2, height / 2, width / 2, colorA, colorB);
        poseStack.func_227865_b_();
    }
}

