/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class LaserParticle
extends CustomModelParticle {
    private float length;
    private float xRot;
    private float yRot;

    public LaserParticle(ClientWorld level, double x, double y, double z, double toX, double toY, double toZ) {
        super(level, x, y, z, 0.0, 0.0, 0.0, ClientModels.LOGICAL_CLIENT.laser);
        this.field_70547_e = 5;
        Vector3d direction = new Vector3d(toX - x, toY - y, toZ - z);
        Vector3d start = new Vector3d(x, y, z);
        Vector3d destination = start.func_178787_e(direction.func_72432_b().func_186678_a(200.0));
        BlockRayTraceResult hitResult = level.func_217299_a(new RayTraceContext(start, destination, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        double xLength = hitResult.func_216347_e().field_72450_a - x;
        double yLength = hitResult.func_216347_e().field_72448_b - y;
        double zLength = hitResult.func_216347_e().field_72449_c - z;
        double horizontalDistance = (float)Math.sqrt(xLength * xLength + zLength * zLength);
        this.length = (float)Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
        this.yRot = (float)(-Math.atan2(zLength, xLength) * 57.29577951308232) - 90.0f;
        this.xRot = (float)(Math.atan2(yLength, horizontalDistance) * 57.29577951308232);
        int smokeCount = (int)this.length * 4;
        for (int i = 0; i < smokeCount; ++i) {
            level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xLength / (double)smokeCount * (double)i, y + yLength / (double)smokeCount * (double)i, z + zLength / (double)smokeCount * (double)i, 0.0, 0.0, 0.0);
        }
        this.func_187108_a(new AxisAlignedBB(x, y, z, toX, toY, toZ));
    }

    @Override
    public void prepareDraw(MatrixStack poseStack, float partialTicks) {
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.yRot));
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.xRot));
        float progression = ((float)this.field_70546_d + partialTicks) / (float)(this.field_70547_e + 1);
        float scale = MathHelper.func_76126_a((float)(progression * (float)Math.PI));
        float zScale = progression > 0.5f ? 1.0f : MathHelper.func_76126_a((float)(progression * (float)Math.PI));
        poseStack.func_227862_a_(scale, scale, zScale * this.length);
    }

    @Override
    public void func_225606_a_(IVertexBuilder vertexConsumer, ActiveRenderInfo camera, float partialTicks) {
        super.func_225606_a_(vertexConsumer, camera, partialTicks);
        MatrixStack poseStack = new MatrixStack();
        this.setupMatrixStack(poseStack, camera, partialTicks);
        this.prepareDraw(poseStack, partialTicks);
        poseStack.func_227862_a_(1.1f, 1.1f, 1.1f);
    }

    public IParticleRenderType func_217558_b() {
        return EpicFightParticleRenderTypes.TRANSLUCENT_GLOWING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements IParticleFactory<BasicParticleType> {
        public Particle createParticle(BasicParticleType typeIn, ClientWorld level, double startX, double startY, double startZ, double endX, double endY, double endZ) {
            return new LaserParticle(level, startX, startY, startZ, endX, endY, endZ);
        }
    }
}

