/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AimAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.EmptyLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedElytraLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedItemInHandLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer
extends PatchedLivingEntityRenderer<ClientPlayerEntity, LocalPlayerPatch, PlayerModel<ClientPlayerEntity>> {
    public FirstPersonRenderer() {
        this.addPatchedLayer(ElytraLayer.class, new PatchedElytraLayer());
        this.addPatchedLayer(HeldItemLayer.class, new PatchedItemInHandLayer());
        this.addPatchedLayer(BipedArmorLayer.class, new WearableItemLayer(true));
        this.addPatchedLayer(HeadLayer.class, new EmptyLayer());
        this.addPatchedLayer(ArrowLayer.class, new EmptyLayer());
        this.addPatchedLayer(BeeStingerLayer.class, new EmptyLayer());
        this.addPatchedLayer(SpinAttackEffectLayer.class, new EmptyLayer());
    }

    @Override
    public void render(ClientPlayerEntity entityIn, LocalPlayerPatch entitypatch, LivingRenderer<ClientPlayerEntity, PlayerModel<ClientPlayerEntity>> renderer, IRenderTypeBuffer buffer, MatrixStack matStackIn, int packedLightIn, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        Vector3d projView = renderInfo.func_216785_c();
        double x = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_()) - projView.func_82615_a();
        double y = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_()) - projView.func_82617_b();
        double z = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_()) - projView.func_82616_c();
        ClientModel model = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        entitypatch.getClientAnimator().setPoseToModel(partialTicks);
        OpenMatrix4f[] poses = armature.getJointTransforms();
        matStackIn.func_227860_a_();
        Vec4f headPos = new Vec4f(0.0f, entityIn.func_70047_e(), 0.0f, 1.0f);
        OpenMatrix4f.transform(poses[9], headPos, headPos);
        float pitch = renderInfo.func_216777_e();
        boolean flag1 = entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() instanceof ActionAnimation;
        boolean flag2 = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation() instanceof AimAnimation;
        float zCoord = flag1 ? 0.0f : poses[0].m32;
        float posZ = Math.min(headPos.z - zCoord, 0.0f);
        if (headPos.z > poses[0].m32) {
            posZ += poses[0].m32 - headPos.z;
        }
        if (!flag2) {
            matStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        }
        float interpolation = pitch > 0.0f ? pitch / 90.0f : 0.0f;
        matStackIn.func_227861_a_(x, y - 0.1 - 0.2 * (flag2 ? 0.8 : (double)interpolation), z + 0.1 + 0.7 * (flag2 ? 0.0 : (double)interpolation) - (double)posZ);
        ClientModel firstModel = entityIn.func_175154_l().equals("slim") ? ClientModels.LOGICAL_CLIENT.playerFirstPersonAlex : ClientModels.LOGICAL_CLIENT.playerFirstPerson;
        firstModel.drawAnimatedModel(matStackIn, buffer.getBuffer(EpicFightRenderTypes.animatedModel(((ClientPlayerEntity)entitypatch.getOriginal()).func_110306_p())), packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.field_229196_a_, poses);
        if (!entityIn.func_175149_v()) {
            this.renderLayer(renderer, entitypatch, entityIn, poses, buffer, matStackIn, packedLightIn, partialTicks);
        }
        matStackIn.func_227865_b_();
    }
}

