/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.LightningRenderHelper;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonCrystalLinkPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

@OnlyIn(value=Dist.CLIENT)
public class PEnderDragonRenderer
extends PatchedEntityRenderer<EnderDragonEntity, EnderDragonPatch, EnderDragonRenderer> {
    private static final ResourceLocation DRAGON_LOCATION = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");

    @Override
    public void render(EnderDragonEntity entityIn, EnderDragonPatch entitypatch, EnderDragonRenderer renderer, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLight, float partialTicks) {
        float deathTimeProgression;
        ClientModel model = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        poseStack.func_227860_a_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poses = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (entityIn.field_70995_bG > 0) {
            poseStack.func_227861_a_(entityIn.func_70681_au().nextGaussian() * 0.08, 0.0, entityIn.func_70681_au().nextGaussian() * 0.08);
            deathTimeProgression = ((float)entityIn.field_70995_bG + partialTicks) / 200.0f;
            IVertexBuilder builder = buffer.getBuffer(EpicFightRenderTypes.dragonExplosionAlphaTriangles(DRAGON_EXPLODING_LOCATION));
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, deathTimeProgression, OverlayTexture.field_229196_a_, poses);
            IVertexBuilder builder2 = buffer.getBuffer(EpicFightRenderTypes.entityDecalTriangles(DRAGON_LOCATION));
            model.drawAnimatedModel(poseStack, builder2, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poses);
        } else {
            IVertexBuilder builder = buffer.getBuffer(EpicFightRenderTypes.animatedModel(DRAGON_LOCATION));
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poses);
        }
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.func_227865_b_();
        if (entityIn.field_70992_bH != null) {
            float x = (float)(entityIn.field_70992_bH.func_226277_ct_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_()));
            float y = (float)(entityIn.field_70992_bH.func_226278_cu_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_()));
            float z = (float)(entityIn.field_70992_bH.func_226281_cx_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_()));
            poseStack.func_227860_a_();
            EnderDragonRenderer.func_229059_a_((float)x, (float)(y + EnderCrystalRenderer.func_229051_a_((EnderCrystalEntity)entityIn.field_70992_bH, (float)partialTicks)), (float)z, (float)partialTicks, (int)entityIn.field_70173_aa, (MatrixStack)poseStack, (IRenderTypeBuffer)buffer, (int)packedLight);
            poseStack.func_227865_b_();
        }
        if (entityIn.field_70995_bG > 0) {
            deathTimeProgression = ((float)entityIn.field_70995_bG + partialTicks) / 200.0f;
            IVertexBuilder lightningBuffer = buffer.getBuffer(RenderType.func_228657_l_());
            int density = (int)((deathTimeProgression + deathTimeProgression * deathTimeProgression) / 2.0f * 60.0f);
            float f7 = Math.min(deathTimeProgression > 0.8f ? (deathTimeProgression - 0.8f) / 0.2f : 0.0f, 1.0f);
            poseStack.func_227860_a_();
            LightningRenderHelper.renderCyclingLight(lightningBuffer, poseStack, 255, 0, 255, density, 1.0f, deathTimeProgression, f7);
            poseStack.func_227865_b_();
        }
    }

    @Override
    public void mulPoseStack(MatrixStack matStack, Armature armature, EnderDragonEntity entityIn, EnderDragonPatch entitypatch, float partialTicks) {
        OpenMatrix4f modelMatrix;
        if (!entitypatch.isGroundPhase() || ((EnderDragonEntity)entitypatch.getOriginal()).field_70995_bG > 0) {
            float f = (float)entityIn.func_70974_a(7, partialTicks)[0];
            float f1 = (float)(entityIn.func_70974_a(5, partialTicks)[1] - entityIn.func_70974_a(10, partialTicks)[1]);
            float f2 = ((EnderDragonEntity)entitypatch.getOriginal()).field_70995_bG > 0 ? 0.0f : MathHelper.func_226168_l_((double)(entityIn.func_70974_a(5, partialTicks)[0] - entityIn.func_70974_a(10, partialTicks)[0]));
            modelMatrix = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f1, f1, f, f, partialTicks, 1.0f, 1.0f, 1.0f).rotateDeg(-f2 * 1.5f, Vec3f.Z_AXIS);
        } else {
            modelMatrix = entitypatch.getModelMatrix(partialTicks).scale(-1.0f, 1.0f, -1.0f);
        }
        OpenMatrix4f transpose = new OpenMatrix4f(modelMatrix).transpose();
        MathUtils.translateStack(matStack, modelMatrix);
        MathUtils.rotateStack(matStack, transpose);
        MathUtils.scaleStack(matStack, transpose);
    }

    protected int getOverlayCoord(EnderDragonEntity entity, EnderDragonPatch entitypatch, float partialTicks) {
        IPhase currentPhase = entity.func_184670_cT().func_188756_a();
        float chargingTick = 158.0f;
        float progression = currentPhase.func_188652_i() == PatchedPhases.CRYSTAL_LINK ? (chargingTick - (float)((DragonCrystalLinkPhase)currentPhase).getChargingCount()) / chargingTick : 0.0f;
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)progression), (int)OverlayTexture.func_229202_a_((entity.field_70737_aN > 5 || entity.field_70725_aQ > 0 ? 1 : 0) != 0));
    }
}

